/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jms.internal;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.apache.aries.transaction.jms.PooledConnectionFactory;
import org.apache.aries.transaction.jms.internal.ConnectionPool;
import org.apache.aries.transaction.jms.internal.XaConnectionPool;

public class XaPooledConnectionFactory
extends PooledConnectionFactory {
    private XAConnectionFactory xaConnectionFactory;
    private TransactionManager transactionManager;

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.setConnectionFactory(new ConnectionFactory(){

            public Connection createConnection() throws JMSException {
                return XaPooledConnectionFactory.this.xaConnectionFactory.createXAConnection();
            }

            public Connection createConnection(String userName, String password) throws JMSException {
                return XaPooledConnectionFactory.this.xaConnectionFactory.createXAConnection(userName, password);
            }
        });
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected ConnectionPool createConnectionPool(Connection connection) throws JMSException {
        return new XaConnectionPool((XAConnection)connection, this.getPoolFactory(), this.getTransactionManager());
    }
}

