/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class RepositoryServiceRepository
implements Repository {
    private final BundleContext context;

    public RepositoryServiceRepository() {
        this(Activator.getInstance().getBundleContext());
    }

    public RepositoryServiceRepository(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Capability> findProviders(Requirement requirement) {
        Collection references;
        HashSet<Capability> result = new HashSet<Capability>();
        try {
            references = this.context.getServiceReferences(Repository.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceReference reference : references) {
            Repository repository = (Repository)this.context.getService(reference);
            try {
                Map map;
                Collection capabilities;
                if (repository == null || (capabilities = (Collection)(map = repository.findProviders(Collections.singleton(requirement))).get(requirement)) == null) continue;
                result.addAll(capabilities);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
        return result;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }
}

