/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.aries.subsystem.AriesSubsystem;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.subsystem.Subsystem;

public class SubsystemServiceRegistrar {
    private final BundleContext context;
    private final Map<Subsystem, ServiceRegistration<?>> map = new HashMap();

    public SubsystemServiceRegistrar(BundleContext context) {
        if (context == null) {
            throw new NullPointerException("Missing required parameter: context");
        }
        this.context = context;
    }

    public synchronized void addRegion(BasicSubsystem subsystem, Region region) {
        String regionName;
        ServiceRegistration<?> registration = this.map.get(subsystem);
        if (registration == null) {
            throw new IllegalStateException("Subsystem '" + subsystem + "' is not registered");
        }
        Collection currentRegions = (Collection)registration.getReference().getProperty("org.apache.aries.subsystem.service.regions");
        if (currentRegions.contains(regionName = region.getName())) {
            return;
        }
        HashSet<String> newRegions = new HashSet<String>(currentRegions.size() + 1);
        newRegions.addAll(currentRegions);
        newRegions.add(regionName);
        Dictionary<String, Object> properties = this.properties(subsystem);
        properties.put("org.apache.aries.subsystem.service.regions", Collections.unmodifiableCollection(newRegions));
        registration.setProperties(properties);
    }

    public synchronized Subsystem getSubsystemService(BasicSubsystem subsystem) {
        ServiceRegistration<?> registration = this.map.get(subsystem);
        if (registration == null) {
            return null;
        }
        return (Subsystem)Activator.getInstance().getBundleContext().getService(registration.getReference());
    }

    public synchronized void register(BasicSubsystem child, BasicSubsystem parent) {
        if (this.map.containsKey(child)) {
            return;
        }
        Dictionary<String, Object> properties = this.properties(child, parent);
        ServiceRegistration registration = this.context.registerService(new String[]{Subsystem.class.getName(), AriesSubsystem.class.getName()}, (Object)child, properties);
        this.map.put(child, registration);
    }

    public synchronized void removeRegion(BasicSubsystem subsystem, Region region) {
        ServiceRegistration<?> registration = this.map.get(subsystem);
        if (registration == null) {
            return;
        }
        HashSet regions = (HashSet)registration.getReference().getProperty("org.apache.aries.subsystem.service.regions");
        String regionName = region.getName();
        if (regions == null || !regions.contains(regionName)) {
            return;
        }
        regions = new HashSet(regions);
        regions.remove(regionName);
        Dictionary<String, Object> properties = this.properties(subsystem);
        properties.put("org.apache.aries.subsystem.service.regions", Collections.unmodifiableCollection(regions));
        registration.setProperties(properties);
    }

    public synchronized void unregister(Subsystem subsystem) {
        ServiceRegistration<?> registration = this.map.remove(subsystem);
        if (registration == null) {
            throw new IllegalStateException("Subsystem '" + subsystem + "' is not registered");
        }
        registration.unregister();
    }

    public synchronized void unregisterAll() {
        Iterator<ServiceRegistration<?>> i = this.map.values().iterator();
        while (i.hasNext()) {
            ServiceRegistration<?> registration = i.next();
            registration.unregister();
            i.remove();
        }
    }

    public synchronized void update(BasicSubsystem subsystem) {
        ServiceRegistration<?> registration = this.map.get(subsystem);
        if (registration == null) {
            throw new IllegalStateException("Subsystem '" + subsystem + "' is not registered");
        }
        Dictionary<String, Object> properties = this.properties(subsystem, registration);
        registration.setProperties(properties);
    }

    private Dictionary<String, Object> properties(BasicSubsystem subsystem) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ((Dictionary)result).put("subsystem.id", subsystem.getSubsystemId());
        ((Dictionary)result).put("subsystem.symbolicName", subsystem.getSymbolicName());
        ((Dictionary)result).put("subsystem.version", subsystem.getVersion());
        ((Dictionary)result).put("subsystem.type", subsystem.getType());
        ((Dictionary)result).put("subsystem.state", (Object)((Object)subsystem.getState()));
        ((Dictionary)result).put("org.apache.aries.subsystem.service.regions", Collections.singleton(subsystem.getRegionName()));
        return result;
    }

    private Dictionary<String, Object> properties(BasicSubsystem child, BasicSubsystem parent) {
        Dictionary<String, Object> result = this.properties(child);
        if (parent == null) {
            return result;
        }
        Collection currentRegions = (Collection)result.get("org.apache.aries.subsystem.service.regions");
        HashSet<String> newRegions = new HashSet<String>(currentRegions.size() + 1);
        newRegions.addAll(currentRegions);
        newRegions.add(parent.getRegion().getName());
        result.put("org.apache.aries.subsystem.service.regions", Collections.unmodifiableCollection(newRegions));
        return result;
    }

    private Dictionary<String, Object> properties(BasicSubsystem subsystem, ServiceRegistration<?> registration) {
        Dictionary<String, Object> result = this.properties(subsystem);
        Collection regions = (Collection)registration.getReference().getProperty("org.apache.aries.subsystem.service.regions");
        if (regions == null) {
            return result;
        }
        result.put("org.apache.aries.subsystem.service.regions", regions);
        return result;
    }
}

