/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;

public class SubsystemTypeHeader
implements Header<Clause> {
    public static final String DIRECTIVE_PROVISION_POLICY = "provision-policy";
    public static final String NAME = "Subsystem-Type";
    public static final String PROVISION_POLICY_ACCEPT_DEPENDENCIES = "acceptDependencies";
    public static final String PROVISION_POLICY_REJECT_DEPENDENCIES = "rejectDependencies";
    public static final String TYPE_APPLICATION = "osgi.subsystem.application";
    public static final String TYPE_COMPOSITE = "osgi.subsystem.composite";
    public static final String TYPE_FEATURE = "osgi.subsystem.feature";
    public static final SubsystemTypeHeader DEFAULT = new SubsystemTypeHeader("osgi.subsystem.application");
    private final Clause clause;

    public SubsystemTypeHeader(Clause clause) {
        if (clause == null) {
            throw new NullPointerException("Missing required parameter: clause");
        }
        this.clause = clause;
    }

    public SubsystemTypeHeader(String value) {
        this(new Clause(value));
    }

    public Clause getClause() {
        return this.clause;
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.singleton(this.clause);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public ProvisionPolicyDirective getProvisionPolicyDirective() {
        return this.clause.getProvisionPolicyDirective();
    }

    public String getType() {
        return this.clause.getType();
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean isApplication() {
        return this == DEFAULT || TYPE_APPLICATION.equals(this.getType());
    }

    public boolean isComposite() {
        return TYPE_COMPOSITE.equals(this.getType());
    }

    public boolean isFeature() {
        return TYPE_FEATURE.equals(this.getType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        private static final Pattern PATTERN_TYPE = Pattern.compile("(osgi.subsystem.application|osgi.subsystem.composite|osgi.subsystem.feature)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private static final Pattern PATTERN_PROVISION_POLICY = Pattern.compile("acceptDependencies|rejectDependencies");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            String value;
            Parameter parameter = parameters.get(SubsystemTypeHeader.DIRECTIVE_PROVISION_POLICY);
            if (parameter == null) {
                parameter = ProvisionPolicyDirective.REJECT_DEPENDENCIES;
            }
            if (!PATTERN_PROVISION_POLICY.matcher(value = ((Directive)parameter).getValue()).matches()) {
                throw new IllegalArgumentException("Invalid provision-policy directive: " + value);
            }
            parameters.put(SubsystemTypeHeader.DIRECTIVE_PROVISION_POLICY, parameter);
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN_TYPE.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid subsystem type: " + clause);
            }
            this.path = matcher.group();
            matcher.usePattern(PATTERN_PARAMETER);
            while (matcher.find()) {
                Parameter parameter = ParameterFactory.create(matcher.group());
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public ProvisionPolicyDirective getProvisionPolicyDirective() {
            return (ProvisionPolicyDirective)this.getDirective(SubsystemTypeHeader.DIRECTIVE_PROVISION_POLICY);
        }

        public String getType() {
            return this.path;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

