/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.BeanProperty;

public class BPBeanProperty
implements TransferObject {
    private String name;
    private BPMetadata value;

    public BPBeanProperty(CompositeData property) {
        this.name = (String)property.get("Name");
        Byte[] buf = (Byte[])property.get("Value");
        this.value = Util.boxedBinary2BPMetadata(buf);
    }

    public BPBeanProperty(BeanProperty property) {
        this.name = property.getName();
        this.value = Util.metadata2BPMetadata(property.getValue());
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Name", this.name);
        items.put("Value", Util.bpMetadata2BoxedBinary(this.value));
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.BEAN_PROPERTY_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public BPMetadata getValue() {
        return this.value;
    }
}

