/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.aries.jmx.codec.PropertyData;
import org.apache.aries.jmx.codec.RoleData;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.User;

public class UserData
extends RoleData {
    protected List<PropertyData<? extends Object>> credentials = new ArrayList<PropertyData<? extends Object>>();

    public UserData(User user) {
        this(user.getName(), user.getType(), user.getProperties(), user.getCredentials());
    }

    public UserData(String name, int type) {
        super(name, type);
    }

    public UserData(String name, int type, Dictionary properties, Dictionary credentials) {
        super(name, type, properties);
        if (credentials != null) {
            Enumeration e = credentials.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                this.credentials.add(PropertyData.newInstance(key, credentials.get(key)));
            }
        }
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            return new CompositeDataSupport(UserAdminMBean.USER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    protected TabularData getCredentialsTable() {
        return UserData.getPropertiesTable(this.credentials);
    }

    public static UserData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        int type = (Integer)data.get("Type");
        return new UserData(name, type, null, null);
    }
}

