/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CaseInsensitiveMap<T>
extends AbstractMap<String, T> {
    private final String[] keys;
    private final Set<Map.Entry<String, T>> properties;

    public CaseInsensitiveMap(final Dictionary<String, T> dictionary) {
        this(() -> {
            HashSet<1> entries = new HashSet<1>(dictionary.size());
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                entries.add(new AbstractMap.SimpleImmutableEntry<String, T>(k, null){

                    @Override
                    public T getValue() {
                        return dictionary.get(this.getKey());
                    }
                });
            }
            return entries;
        });
    }

    public CaseInsensitiveMap(Map<String, T> properties) {
        this(() -> properties.entrySet());
    }

    CaseInsensitiveMap(Supplier<Set<Map.Entry<String, T>>> properties) {
        this.properties = properties.get().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList keyList = new ArrayList(this.properties.size());
        this.properties.forEach((? super T e) -> {
            for (String i : keyList) {
                if (!((String)e.getKey()).equalsIgnoreCase(i)) continue;
                throw new IllegalArgumentException();
            }
            keyList.add((String)e.getKey());
        });
        this.keys = keyList.toArray(new String[0]);
    }

    @Override
    public T get(Object o) {
        String k = (String)o;
        for (String key : this.keys) {
            if (!key.equalsIgnoreCase(k)) continue;
            return (T)super.get(key);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.properties;
    }
}

