/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Feature;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.rest.management.feature.RestManagementFeature;
import org.apache.aries.jax.rs.rest.management.internal.RestManagementApplication;
import org.apache.aries.jax.rs.rest.management.internal.client.RestClientFactoryImpl;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.rest.RestApiExtension;
import org.osgi.service.rest.client.RestClientFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class RestManagementActivator
implements BundleActivator {
    public static final String RMS_BASE = "/rms";
    private OSGiResult result;

    public void start(BundleContext bundleContext) throws Exception {
        this.result = OSGi.all((OSGi[])new OSGi[]{OSGi.ignore((OSGi)OSGi.just((Object)((Object)new RestManagementApplication(bundleContext))).flatMap(application -> OSGi.register(Application.class, () -> application, () -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("osgi.jaxrs.name", RestManagementApplication.class.getSimpleName());
            map.put("osgi.jaxrs.application.base", RMS_BASE);
            return map;
        }).then(RestManagementActivator.dynamic(OSGi.serviceReferences(RestApiExtension.class, (String)"(&(org.osgi.rest.name=*)(org.osgi.rest.uri.path=*))"), application::addExtension, application::removeExtension)))), OSGi.ignore((OSGi)OSGi.service((OSGi)OSGi.serviceReferences(ClientBuilder.class)).flatMap(clientBuilder -> OSGi.register(RestClientFactory.class, (Object)new RestClientFactoryImpl((ClientBuilder)clientBuilder), null))), OSGi.ignore((OSGi)OSGi.register(Feature.class, new PrototypeWrapper<Feature>((b, r) -> new RestManagementFeature()), () -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("osgi.jaxrs.name", RestManagementFeature.class.getSimpleName());
            map.put("osgi.jaxrs.application.select", String.format("(%s=%s)", "osgi.jaxrs.name", RestManagementApplication.class.getSimpleName()));
            map.put("osgi.jaxrs.extension", true);
            return map;
        })), OSGi.ignore((OSGi)OSGi.register(OpenAPI.class, () -> {
            OpenAPI openAPI = new OpenAPI();
            openAPI.info(new Info().title("Apache Aries OSGi Rest Management Service").description("A REST API to manage an OSGi Framework").license(new License().name("Apache 2.0").url("https://www.apache.org/licenses/LICENSE-2.0.html")).version("1.0.0").contact(new Contact().email("dev@aries.apache.org"))).externalDocs(new ExternalDocumentation().description("OSGi Compendium Chapter 137 - REST Management Service Specification").url("https://docs.osgi.org/specification/osgi.cmpn/7.0.0/service.rest.html"));
            return openAPI;
        }, () -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("osgi.jaxrs.application.select", String.format("(%s=%s)", "osgi.jaxrs.name", RestManagementApplication.class.getSimpleName()));
            return map;
        }))}).run(bundleContext);
    }

    public void stop(BundleContext context) throws Exception {
        this.result.close();
    }

    public static <T> OSGi<Void> dynamic(OSGi<T> program, Consumer<T> bind, Consumer<T> unbind) {
        return program.foreach(bind, unbind);
    }

    class PrototypeWrapper<S>
    implements PrototypeServiceFactory<S> {
        private final BiFunction<Bundle, ServiceRegistration<S>, S> function;

        public PrototypeWrapper(BiFunction<Bundle, ServiceRegistration<S>, S> function) {
            this.function = function;
        }

        public S getService(Bundle bundle, ServiceRegistration<S> registration) {
            return this.function.apply(bundle, registration);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
        }
    }
}

