/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.aries.blueprint.mutable.MutablePropsMetadata;
import org.apache.aries.blueprint.reflect.MapEntryImpl;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;

public class PropsMetadataImpl
implements MutablePropsMetadata {
    private List<MapEntry> entries;

    public PropsMetadataImpl() {
    }

    public PropsMetadataImpl(List<MapEntry> entries) {
        this.entries = entries;
    }

    public PropsMetadataImpl(PropsMetadata source) {
        for (MapEntry entry : source.getEntries()) {
            this.addEntry(new MapEntryImpl(entry));
        }
    }

    @Override
    public List<MapEntry> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<MapEntry> entries) {
        this.entries = entries != null ? new ArrayList<MapEntry>(entries) : null;
    }

    @Override
    public void addEntry(MapEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<MapEntry>();
        }
        this.entries.add(entry);
    }

    @Override
    public MapEntry addEntry(NonNullMetadata key, Metadata value) {
        MapEntryImpl entry = new MapEntryImpl(key, value);
        this.addEntry(entry);
        return entry;
    }

    @Override
    public void removeEntry(MapEntry entry) {
        if (this.entries != null) {
            this.entries.remove(entry);
        }
    }

    public String toString() {
        return "PropsMetadata[entries=" + this.entries + ']';
    }
}

