/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.Drainable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AvroInputStream
extends InputStream
implements Drainable {
    private ByteArrayInputStream partial;

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getPartialInternal().read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.getPartialInternal().read();
    }

    private ByteArrayInputStream getPartialInternal() throws IOException {
        if (this.partial == null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.drainTo(outputStream);
            this.partial = new ByteArrayInputStream(outputStream.toByteArray());
        }
        return this.partial;
    }

    protected ByteArrayInputStream getPartial() {
        return this.partial;
    }

    protected static class CountingOutputStream
    extends OutputStream {
        private final OutputStream target;
        private int writtenCount = 0;

        public CountingOutputStream(OutputStream target) {
            this.target = target;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.target.write(b, off, len);
            this.writtenCount += len;
        }

        @Override
        public void write(int b) throws IOException {
            this.target.write(b);
            ++this.writtenCount;
        }

        @Override
        public void flush() throws IOException {
            this.target.flush();
        }

        @Override
        public void close() throws IOException {
            this.target.close();
        }

        public int getWrittenCount() {
            return this.writtenCount;
        }
    }
}

