/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.result;

import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.result.IResultDirectory;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.IResultSetReader;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.client.net.ClientNetworkManager;
import org.apache.hyracks.client.result.ResultDirectory;
import org.apache.hyracks.client.result.ResultSetReader;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;

public class ResultSet
implements IResultSet {
    private final IResultDirectory resultDirectory;
    private final ClientNetworkManager netManager;
    private final IHyracksCommonContext resultClientCtx;

    public ResultSet(IHyracksClientConnection hcc, ISocketChannelFactory socketChannelFactory, int frameSize, int nReaders) throws Exception {
        NetworkAddress ddsAddress = hcc.getResultDirectoryAddress();
        this.resultDirectory = new ResultDirectory(ddsAddress.getAddress(), ddsAddress.getPort(), socketChannelFactory);
        this.netManager = new ClientNetworkManager(nReaders, socketChannelFactory);
        this.netManager.start();
        this.resultClientCtx = new ResultClientContext(frameSize);
    }

    public IResultSetReader createReader(JobId jobId, ResultSetId resultSetId) throws HyracksDataException {
        ResultSetReader reader = null;
        try {
            reader = new ResultSetReader(this.resultDirectory, this.netManager, this.resultClientCtx, jobId, resultSetId);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return reader;
    }

    static class ResultClientContext
    extends FrameManager
    implements IHyracksCommonContext {
        ResultClientContext(int frameSize) {
            super(frameSize);
        }

        public IIOManager getIoManager() {
            return null;
        }
    }
}

