/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public class InsertUpsertCheckUtil {
    private InsertUpsertCheckUtil() {
    }

    public static boolean check(ILogicalOperator op) {
        return InsertUpsertCheckUtil.checkTopDown(op, false);
    }

    private static boolean checkTopDown(ILogicalOperator op, boolean hasSubplanAboveWithDatasetAccess) {
        boolean metSubplanWithDataScan = hasSubplanAboveWithDatasetAccess;
        if (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
            SubplanOperator subplanOp = (SubplanOperator)op;
            metSubplanWithDataScan = InsertUpsertCheckUtil.containsDatasetAccess(subplanOp);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.INSERT_DELETE_UPSERT && metSubplanWithDataScan) {
            return true;
        }
        for (Mutable inputOpRef : op.getInputs()) {
            if (!InsertUpsertCheckUtil.checkTopDown((ILogicalOperator)inputOpRef.getValue(), metSubplanWithDataScan)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDatasetAccess(SubplanOperator subplanOp) {
        List nestedPlans = subplanOp.getNestedPlans();
        for (ILogicalPlan nestedPlan : nestedPlans) {
            for (Mutable opRef : nestedPlan.getRoots()) {
                if (!InsertUpsertCheckUtil.containsDatasetAccessInternal((ILogicalOperator)opRef.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsDatasetAccessInternal(ILogicalOperator op) {
        if (op.getOperatorTag() == LogicalOperatorTag.UNNEST) {
            UnnestOperator unnestOp = (UnnestOperator)op;
            ILogicalExpression unnestExpr = (ILogicalExpression)unnestOp.getExpressionRef().getValue();
            UnnestingFunctionCallExpression unnestingFuncExpr = (UnnestingFunctionCallExpression)unnestExpr;
            return unnestingFuncExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.DATASET);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN && InsertUpsertCheckUtil.containsDatasetAccess((SubplanOperator)op)) {
            return true;
        }
        for (Mutable childRef : op.getInputs()) {
            if (!InsertUpsertCheckUtil.containsDatasetAccessInternal((ILogicalOperator)childRef.getValue())) continue;
            return true;
        }
        return false;
    }
}

