/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;

public class AnalysisUtil {
    private static List<FunctionIdentifier> fieldAccessFunctions = new ArrayList<FunctionIdentifier>();

    public static final ILogicalOperator firstChildOfType(AbstractLogicalOperator op, LogicalOperatorTag opType) {
        List ins = op.getInputs();
        if (ins == null || ins.isEmpty()) {
            return null;
        }
        Mutable opRef2 = (Mutable)ins.get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == opType) {
            return op2;
        }
        return null;
    }

    public static int numberOfVarsInExpr(ILogicalExpression e) {
        switch (e.getExpressionTag()) {
            case CONSTANT: {
                return 0;
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)e;
                int s = 0;
                for (Mutable arg : f.getArguments()) {
                    s += AnalysisUtil.numberOfVarsInExpr((ILogicalExpression)arg.getValue());
                }
                return s;
            }
            case VARIABLE: {
                return 1;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    public static boolean isRunnableFieldAccessFunction(FunctionIdentifier fid) {
        return fieldAccessFunctions.contains(fid);
    }

    public static boolean isRunnableAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && AnalysisUtil.isRunnableFieldAccessFunction(fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier());
    }

    public static boolean isAccessByNameToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME);
    }

    public static boolean isAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED));
    }

    public static Pair<DataverseName, String> getDatasetInfo(AbstractDataSourceOperator op) {
        DataSourceId srcId = (DataSourceId)op.getDataSource().getId();
        return new Pair((Object)srcId.getDataverseName(), (Object)srcId.getDatasourceName());
    }

    public static Pair<DataverseName, String> getExternalDatasetInfo(UnnestMapOperator op) throws AlgebricksException {
        AbstractFunctionCallExpression unnestExpr = (AbstractFunctionCallExpression)op.getExpressionRef().getValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(0))));
        String datasetName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(1)));
        return new Pair((Object)dataverseName, (Object)datasetName);
    }

    public static boolean hasFunctionWithProperty(WindowOperator winOp, BuiltinFunctions.WindowFunctionProperty property) throws CompilationException {
        for (Mutable exprRef : winOp.getExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, winOp.getSourceLocation(), new Serializable[]{expr.getExpressionTag()});
            }
            AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
            if (!BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)callExpr.getFunctionIdentifier(), (BuiltinFunctions.BuiltinFunctionProperty)property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWindowFrameBoundaryMonotonic(List<Mutable<ILogicalExpression>> frameBoundaryExprList, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExprList) {
        if (frameValueExprList.size() != 1) {
            return false;
        }
        ILogicalExpression frameValueExpr = (ILogicalExpression)((Mutable)frameValueExprList.get((int)0).second).getValue();
        if (frameValueExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (frameBoundaryExprList.size() != 1) {
            return false;
        }
        ILogicalExpression frameStartExpr = (ILogicalExpression)frameBoundaryExprList.get(0).getValue();
        switch (frameStartExpr.getExpressionTag()) {
            case CONSTANT: {
                return true;
            }
            case VARIABLE: {
                return frameStartExpr.equals(frameValueExpr);
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression frameStartCallExpr = (AbstractFunctionCallExpression)frameStartExpr;
                FunctionIdentifier fi = frameStartCallExpr.getFunctionIdentifier();
                return (BuiltinFunctions.NUMERIC_ADD.equals((Object)fi) || BuiltinFunctions.NUMERIC_SUBTRACT.equals((Object)fi)) && ((ILogicalExpression)((Mutable)frameStartCallExpr.getArguments().get(0)).getValue()).equals(frameValueExpr) && ((ILogicalExpression)((Mutable)frameStartCallExpr.getArguments().get(1)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT;
            }
        }
        throw new IllegalStateException(String.valueOf(frameStartExpr.getExpressionTag()));
    }

    public static boolean isTrivialAggregateSubplan(ILogicalPlan subplan) {
        if (subplan.getRoots().isEmpty()) {
            return false;
        }
        for (Mutable rootOpRef : subplan.getRoots()) {
            ILogicalOperator rootOp = (ILogicalOperator)rootOpRef.getValue();
            if (rootOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
                return false;
            }
            if (AnalysisUtil.firstChildOfType((AbstractLogicalOperator)rootOp, LogicalOperatorTag.NESTEDTUPLESOURCE) != null) continue;
            return false;
        }
        return true;
    }

    static {
        fieldAccessFunctions.add(BuiltinFunctions.GET_DATA);
        fieldAccessFunctions.add(BuiltinFunctions.GET_HANDLE);
        fieldAccessFunctions.add(BuiltinFunctions.TYPE_OF);
    }
}

