/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;

public abstract class AbstractLSMWithBuddyMemoryComponent
extends AbstractLSMMemoryComponent {
    public AbstractLSMWithBuddyMemoryComponent(AbstractLSMIndex lsmIndex, IVirtualBufferCache vbc, ILSMComponentFilter filter) {
        super(lsmIndex, vbc, filter);
    }

    public abstract AbstractTreeIndex getBuddyIndex();

    @Override
    public void cleanup() throws HyracksDataException {
        if (this.allocated.get()) {
            super.cleanup();
            this.getBuddyIndex().deactivate();
            this.getBuddyIndex().destroy();
        }
    }

    @Override
    public void doAllocate() throws HyracksDataException {
        super.doAllocate();
        this.getBuddyIndex().create();
        this.getBuddyIndex().activate();
    }

    @Override
    public void doDeallocate() throws HyracksDataException {
        if (this.allocated.get()) {
            super.doDeallocate();
            this.getBuddyIndex().deactivate();
            this.getBuddyIndex().destroy();
        }
    }

    @Override
    public void validate() throws HyracksDataException {
        super.validate();
        this.getBuddyIndex().validate();
    }
}

