/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.expression.AbstractCallExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppFunctionBodyRewriter;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.GenerateColumnNameVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineColumnAliasVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineWithExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.OperatorExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppCaseAggregateExtractionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppCaseExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppFunctionCallResolverVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGatherFunctionCallsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupingSetsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppInlineUdfsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppListInputFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppRightJoinRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppSpecialFunctionNameRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SubstituteGroupbyExpressionWithVariableVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.VariableCheckAndRewriteVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppAstPrintUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Function;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlppQueryRewriter
implements IQueryRewriter {
    private static final Logger LOGGER = LogManager.getLogger(SqlppQueryRewriter.class);
    public static final String INLINE_WITH_OPTION = "inline_with";
    private static final boolean INLINE_WITH_OPTION_DEFAULT = true;
    private final IParserFactory parserFactory;
    private SqlppFunctionBodyRewriter functionBodyRewriter;
    private IReturningStatement topStatement;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;
    private Collection<VarIdentifier> externalVars;
    private boolean allowNonStoredUdfCalls;
    private boolean inlineUdfs;
    private boolean isLogEnabled;

    public SqlppQueryRewriter(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    protected void setup(LangRewritingContext context, IReturningStatement topStatement, Collection<VarIdentifier> externalVars, boolean allowNonStoredUdfCalls, boolean inlineUdfs) throws CompilationException {
        this.context = context;
        this.metadataProvider = context.getMetadataProvider();
        this.topStatement = topStatement;
        this.externalVars = externalVars != null ? externalVars : Collections.emptyList();
        this.allowNonStoredUdfCalls = allowNonStoredUdfCalls;
        this.inlineUdfs = inlineUdfs;
        this.isLogEnabled = LOGGER.isTraceEnabled();
        this.logExpression("Starting AST rewrites on", "");
    }

    public void rewrite(LangRewritingContext context, IReturningStatement topStatement, boolean allowNonStoredUdfCalls, boolean inlineUdfs, Collection<VarIdentifier> externalVars) throws CompilationException {
        this.setup(context, topStatement, externalVars, allowNonStoredUdfCalls, inlineUdfs);
        this.resolveFunctionCalls();
        this.generateColumnNames();
        this.substituteGroupbyKeyExpression();
        this.rewriteGroupBys();
        this.rewriteSetOperations();
        this.inlineColumnAlias();
        this.rewriteWindowExpressions();
        this.rewriteGroupingSets();
        this.variableCheckAndRewrite();
        this.extractAggregatesFromCaseExpressions();
        this.rewriteGroupByAggregationSugar();
        this.rewriteWindowAggregationSugar();
        this.rewriteOperatorExpression();
        this.rewriteCaseExpressions();
        this.rewriteListInputFunctions();
        this.rewriteRightJoins();
        this.loadAndInlineDeclaredUdfs();
        this.rewriteSpecialFunctionNames();
        this.inlineWithExpressions();
        topStatement.setVarCounter(context.getVarCounter().get());
    }

    protected void rewriteGroupByAggregationSugar() throws CompilationException {
        SqlppGroupByAggregationSugarVisitor visitor = new SqlppGroupByAggregationSugarVisitor(this.context, this.externalVars);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteListInputFunctions() throws CompilationException {
        SqlppListInputFunctionRewriteVisitor listInputFunctionVisitor = new SqlppListInputFunctionRewriteVisitor();
        this.rewriteTopExpr(listInputFunctionVisitor, null);
    }

    protected void resolveFunctionCalls() throws CompilationException {
        SqlppFunctionCallResolverVisitor visitor = new SqlppFunctionCallResolverVisitor(this.context, this.allowNonStoredUdfCalls);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteSpecialFunctionNames() throws CompilationException {
        SqlppSpecialFunctionNameRewriteVisitor visitor = new SqlppSpecialFunctionNameRewriteVisitor();
        this.rewriteTopExpr(visitor, null);
    }

    protected void inlineWithExpressions() throws CompilationException {
        if (!this.metadataProvider.getBooleanProperty(INLINE_WITH_OPTION, true)) {
            return;
        }
        InlineWithExpressionVisitor inlineWithExpressionVisitor = new InlineWithExpressionVisitor(this.context, this.metadataProvider);
        this.rewriteTopExpr(inlineWithExpressionVisitor, null);
    }

    protected void generateColumnNames() throws CompilationException {
        GenerateColumnNameVisitor generateColumnNameVisitor = new GenerateColumnNameVisitor(this.context);
        this.rewriteTopExpr(generateColumnNameVisitor, null);
    }

    protected void substituteGroupbyKeyExpression() throws CompilationException {
        SubstituteGroupbyExpressionWithVariableVisitor substituteGbyExprVisitor = new SubstituteGroupbyExpressionWithVariableVisitor(this.context);
        this.rewriteTopExpr(substituteGbyExprVisitor, null);
    }

    protected void rewriteSetOperations() throws CompilationException {
        SetOperationVisitor setOperationVisitor = new SetOperationVisitor(this.context);
        this.rewriteTopExpr(setOperationVisitor, null);
    }

    protected void rewriteOperatorExpression() throws CompilationException {
        OperatorExpressionVisitor operatorExpressionVisitor = new OperatorExpressionVisitor(this.context);
        this.rewriteTopExpr(operatorExpressionVisitor, null);
    }

    protected void inlineColumnAlias() throws CompilationException {
        InlineColumnAliasVisitor inlineColumnAliasVisitor = new InlineColumnAliasVisitor(this.context);
        this.rewriteTopExpr(inlineColumnAliasVisitor, null);
    }

    protected void variableCheckAndRewrite() throws CompilationException {
        VariableCheckAndRewriteVisitor variableCheckAndRewriteVisitor = new VariableCheckAndRewriteVisitor(this.context, this.metadataProvider, this.externalVars);
        this.rewriteTopExpr(variableCheckAndRewriteVisitor, null);
    }

    protected void rewriteGroupBys() throws CompilationException {
        SqlppGroupByVisitor groupByVisitor = new SqlppGroupByVisitor(this.context);
        this.rewriteTopExpr(groupByVisitor, null);
    }

    protected void rewriteGroupingSets() throws CompilationException {
        SqlppGroupingSetsVisitor groupingSetsVisitor = new SqlppGroupingSetsVisitor(this.context);
        this.rewriteTopExpr(groupingSetsVisitor, null);
    }

    protected void rewriteWindowExpressions() throws CompilationException {
        SqlppWindowRewriteVisitor windowVisitor = new SqlppWindowRewriteVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void rewriteWindowAggregationSugar() throws CompilationException {
        SqlppWindowAggregationSugarVisitor windowVisitor = new SqlppWindowAggregationSugarVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void extractAggregatesFromCaseExpressions() throws CompilationException {
        SqlppCaseAggregateExtractionVisitor visitor = new SqlppCaseAggregateExtractionVisitor(this.context);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteCaseExpressions() throws CompilationException {
        SqlppCaseExpressionVisitor visitor = new SqlppCaseExpressionVisitor();
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteRightJoins() throws CompilationException {
        SqlppRightJoinRewriteVisitor visitor = new SqlppRightJoinRewriteVisitor(this.context, this.externalVars);
        this.rewriteTopExpr(visitor, null);
    }

    protected void loadAndInlineDeclaredUdfs() throws CompilationException {
        Map<FunctionSignature, FunctionDecl> udfs = this.fetchUserDefinedSqlppFunctions(this.topStatement);
        FunctionUtil.checkFunctionRecursion(udfs, SqlppGatherFunctionCallsVisitor::new, (SourceLocation)this.topStatement.getSourceLocation());
        if (!udfs.isEmpty() && this.inlineUdfs) {
            SqlppInlineUdfsVisitor visitor = new SqlppInlineUdfsVisitor(this.context, udfs);
            while (this.rewriteTopExpr(visitor, null).booleanValue()) {
            }
        }
    }

    private <R, T> R rewriteTopExpr(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        Object result = this.topStatement.accept(visitor, arg);
        this.logExpression(">>>> AST After", visitor.getClass().getSimpleName());
        return (R)result;
    }

    private void logExpression(String p0, String p1) throws CompilationException {
        if (this.isLogEnabled) {
            LOGGER.trace("{} {}\n{}", (Object)p0, (Object)p1, (Object)LogRedactionUtil.userData((String)SqlppAstPrintUtil.toString((ILangExpression)this.topStatement)));
        }
    }

    public void getFunctionCalls(Expression expression, Collection<? super AbstractCallExpression> outCalls) throws CompilationException {
        SqlppGatherFunctionCallsVisitor gfc = new SqlppGatherFunctionCallsVisitor(outCalls);
        expression.accept((ILangVisitor)gfc, null);
    }

    public Set<VariableExpr> getExternalVariables(Expression expr) throws CompilationException {
        Set<VariableExpr> freeVars = SqlppVariableUtil.getFreeVariables((ILangExpression)expr);
        HashSet<VariableExpr> extVars = new HashSet<VariableExpr>();
        for (VariableExpr ve : freeVars) {
            if (!SqlppVariableUtil.isExternalVariableReference(ve)) continue;
            extVars.add(ve);
        }
        return extVars;
    }

    private Map<FunctionSignature, FunctionDecl> fetchUserDefinedSqlppFunctions(IReturningStatement topExpr) throws CompilationException {
        AbstractCallExpression fnCall;
        LinkedHashMap<FunctionSignature, FunctionDecl> udfs = new LinkedHashMap<FunctionSignature, FunctionDecl>();
        ArrayDeque workQueue = new ArrayDeque();
        SqlppGatherFunctionCallsVisitor gfc = new SqlppGatherFunctionCallsVisitor(workQueue);
        for (Expression expr : topExpr.getDirectlyEnclosedExpressions()) {
            expr.accept((ILangVisitor)gfc, null);
        }
        block7: while ((fnCall = (AbstractCallExpression)workQueue.poll()) != null) {
            switch (fnCall.getKind()) {
                case CALL_EXPRESSION: {
                    FunctionSignature fs = fnCall.getFunctionSignature();
                    DataverseName fsDataverse = fs.getDataverseName();
                    if (fsDataverse == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fnCall.getSourceLocation(), new Serializable[]{fs});
                    }
                    if (FunctionUtil.isBuiltinFunctionSignature((FunctionSignature)fs) || udfs.containsKey(fs)) continue block7;
                    FunctionDecl fd = (FunctionDecl)this.context.getDeclaredFunctions().get(fs);
                    if (fd == null) {
                        Function function;
                        try {
                            function = this.metadataProvider.lookupUserDefinedFunction(fs);
                        }
                        catch (AlgebricksException e) {
                            throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, fnCall.getSourceLocation(), new Serializable[]{fs.toString()});
                        }
                        if (function == null) {
                            throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, fnCall.getSourceLocation(), new Serializable[]{fs.toString()});
                        }
                        if (function.isExternal()) continue block7;
                        fd = FunctionUtil.parseStoredFunction((Function)function, (IParserFactory)this.parserFactory, (IWarningCollector)this.context.getWarningCollector(), (SourceLocation)fnCall.getSourceLocation());
                    }
                    this.prepareFunction(fd);
                    udfs.put(fs, fd);
                    fd.getNormalizedFuncBody().accept((ILangVisitor)gfc, null);
                    continue block7;
                }
                case WINDOW_EXPRESSION: {
                    continue block7;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fnCall.getSourceLocation(), new Serializable[]{fnCall.getFunctionSignature().toString(false)});
        }
        return udfs;
    }

    private void prepareFunction(FunctionDecl fd) throws CompilationException {
        Expression fnNormBody = fd.getNormalizedFuncBody();
        if (fnNormBody == null) {
            fnNormBody = this.rewriteFunctionBody(fd);
            fd.setNormalizedFuncBody(fnNormBody);
        }
    }

    private Expression rewriteFunctionBody(FunctionDecl fnDecl) throws CompilationException {
        Dataverse fnDataverse;
        DataverseName fnDataverseName = fnDecl.getSignature().getDataverseName();
        Dataverse defaultDataverse = this.metadataProvider.getDefaultDataverse();
        if (fnDataverseName == null || fnDataverseName.equals((Object)defaultDataverse.getDataverseName())) {
            fnDataverse = defaultDataverse;
        } else {
            try {
                fnDataverse = this.metadataProvider.findDataverse(fnDataverseName);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, (Throwable)e, fnDecl.getSourceLocation(), new Serializable[]{fnDataverseName});
            }
        }
        this.metadataProvider.setDefaultDataverse(fnDataverse);
        try {
            Query wrappedQuery = new Query(false);
            wrappedQuery.setSourceLocation(fnDecl.getSourceLocation());
            wrappedQuery.setBody(fnDecl.getFuncBody());
            wrappedQuery.setTopLevel(false);
            boolean allowNonStoredUdfCalls = !fnDecl.isStored();
            this.getFunctionBodyRewriter().rewrite(this.context, (IReturningStatement)wrappedQuery, allowNonStoredUdfCalls, false, fnDecl.getParamList());
            Expression expression = wrappedQuery.getBody();
            return expression;
        }
        catch (CompilationException e) {
            throw new CompilationException(ErrorCode.COMPILATION_BAD_FUNCTION_DEFINITION, (Throwable)e, new Serializable[]{fnDecl.getSignature(), e.getMessage()});
        }
        finally {
            this.metadataProvider.setDefaultDataverse(defaultDataverse);
        }
    }

    protected SqlppFunctionBodyRewriter getFunctionBodyRewriter() {
        if (this.functionBodyRewriter == null) {
            this.functionBodyRewriter = new SqlppFunctionBodyRewriter(this.parserFactory);
        }
        return this.functionBodyRewriter;
    }
}

