/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.util.List;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.CcIdentifiedMessage;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.utils.NcLocalCounters;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrationTasksResponseMessage
extends CcIdentifiedMessage
implements INCLifecycleMessage,
INcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final List<INCLifecycleTask> tasks;

    public RegistrationTasksResponseMessage(String nodeId, List<INCLifecycleTask> tasks) {
        this.nodeId = nodeId;
        this.tasks = tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        IControllerService cs = appCtx.getServiceContext().getControllerService();
        boolean success = true;
        try {
            Throwable exception = null;
            try {
                for (INCLifecycleTask task : this.tasks) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.log(Level.INFO, "Starting startup task: " + task);
                    }
                    task.perform(this.getCcId(), cs);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.log(Level.INFO, "Completed startup task: " + task);
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.ERROR, "Failed during startup task", e);
                success = false;
                exception = e;
            }
            NcLocalCounters localCounter = success ? NcLocalCounters.collect((CcId)this.getCcId(), (NodeControllerService)((NodeControllerService)appCtx.getServiceContext().getControllerService())) : null;
            NCLifecycleTaskReportMessage result = new NCLifecycleTaskReportMessage(this.nodeId, success, localCounter);
            result.setException(exception);
            try {
                broker.sendMessageToCC(this.getCcId(), (ICcAddressedMessage)result);
            }
            catch (Exception e) {
                success = false;
                LOGGER.log(Level.ERROR, "Failed sending message to cc", (Throwable)e);
            }
        }
        finally {
            if (!success) {
                ExitUtil.exit((int)2);
            }
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.REGISTRATION_TASKS_RESPONSE;
    }
}

