/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.util.Collection;
import org.apache.asterix.app.message.ClientRequestsResponse;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientRequestsRequest
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final long reqId;
    private final RequestType requestType;

    public ClientRequestsRequest(String nodeId, long reqId, RequestType requestType) {
        this.nodeId = nodeId;
        this.reqId = reqId;
        this.requestType = requestType;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        Collection clientRequests;
        switch (this.requestType) {
            case RUNNING: {
                clientRequests = appCtx.getRequestTracker().getRunningRequests();
                break;
            }
            case COMPLETED: {
                clientRequests = appCtx.getRequestTracker().getCompletedRequests();
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized request type: " + this.requestType);
            }
        }
        String[] requests = (String[])clientRequests.stream().map(IClientRequest::toJson).toArray(String[]::new);
        ClientRequestsResponse response = new ClientRequestsResponse(this.reqId, requests);
        CCMessageBroker messageBroker = (CCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            messageBroker.sendApplicationMessageToNC(response, this.nodeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure sending response to nc", (Throwable)e);
        }
    }

    public static enum RequestType {
        RUNNING,
        COMPLETED;

    }
}

