/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.app.function.FunctionReader;
import org.apache.asterix.common.context.DatasetResource;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;

public class StorageComponentsReader
extends FunctionReader {
    private final List<String> components = new ArrayList<String>();
    private final Iterator<String> it;
    private final CharArrayRecord record;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageComponentsReader(String nodeId, DatasetResource dsr) throws HyracksDataException {
        if (dsr != null && dsr.isOpen()) {
            Map indexes = dsr.getIndexes();
            StringBuilder strBuilder = new StringBuilder();
            for (Map.Entry entry : indexes.entrySet()) {
                strBuilder.setLength(0);
                IndexInfo value = (IndexInfo)entry.getValue();
                ILSMIndex index = value.getIndex();
                String path = value.getLocalResource().getPath();
                strBuilder.append('{');
                strBuilder.append("\"node\":\"");
                strBuilder.append(nodeId);
                strBuilder.append("\", \"path\":\"");
                strBuilder.append(path);
                strBuilder.append("\", \"components\":[");
                ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
                synchronized (iLSMOperationTracker) {
                    List diskComponents = index.getDiskComponents();
                    for (int i = diskComponents.size() - 1; i >= 0; --i) {
                        if (i < diskComponents.size() - 1) {
                            strBuilder.append(',');
                        }
                        ILSMDiskComponent c = (ILSMDiskComponent)diskComponents.get(i);
                        LSMComponentId id = (LSMComponentId)c.getId();
                        strBuilder.append('{');
                        strBuilder.append("\"min\":");
                        strBuilder.append(id.getMinId());
                        strBuilder.append(",\"max\":");
                        strBuilder.append(id.getMaxId());
                        strBuilder.append('}');
                    }
                }
                strBuilder.append("]}");
                this.components.add(strBuilder.toString());
            }
            this.record = new CharArrayRecord();
        } else {
            this.record = null;
        }
        this.it = this.components.iterator();
    }

    public boolean hasNext() throws Exception {
        return this.it.hasNext();
    }

    public IRawRecord<char[]> next() throws IOException, InterruptedException {
        this.record.reset();
        this.record.append(this.it.next().toCharArray());
        this.record.endRecord();
        return this.record;
    }
}

