/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.common.ResultMetadata;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResponseMetrics;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.app.result.fields.MetricsPrinter;
import org.apache.asterix.app.result.fields.ProfilePrinter;
import org.apache.asterix.app.result.fields.ResultsPrinter;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryResultApiServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public QueryResultApiServlet(ConcurrentMap<String, Object> ctx, IApplicationContext appCtx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        long elapsedStart = System.nanoTime();
        HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (IServletRequest)request);
        String strHandle = this.localPath(request);
        ResultHandle handle = ResultHandle.parse(strHandle);
        if (handle == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        IResultSet resultSet = this.getResultSet();
        ResultReader resultReader = new ResultReader(resultSet, handle.getJobId(), handle.getResultSetId());
        try {
            HttpResponseStatus httpStatus;
            ResultJobRecord.Status status = resultReader.getStatus();
            if (status == null) {
                httpStatus = HttpResponseStatus.NOT_FOUND;
            } else {
                switch (status.getState()) {
                    case SUCCESS: {
                        httpStatus = HttpResponseStatus.OK;
                        break;
                    }
                    case RUNNING: 
                    case IDLE: 
                    case FAILED: {
                        httpStatus = HttpResponseStatus.NOT_FOUND;
                        break;
                    }
                    default: {
                        httpStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    }
                }
            }
            response.setStatus(httpStatus);
            if (httpStatus != HttpResponseStatus.OK) {
                return;
            }
            ResultMetadata metadata = (ResultMetadata)resultReader.getMetadata();
            SessionOutput sessionOutput = QueryResultApiServlet.initResponse(request, response, metadata.getFormat());
            ResponsePrinter printer = new ResponsePrinter(sessionOutput);
            if (metadata.getFormat() == SessionConfig.OutputFormat.CLEAN_JSON || metadata.getFormat() == SessionConfig.OutputFormat.LOSSLESS_JSON) {
                IStatementExecutor.Stats stats = new IStatementExecutor.Stats();
                printer.begin();
                printer.addResultPrinter(new ResultsPrinter(this.appCtx, resultReader, null, stats, sessionOutput));
                printer.printResults();
                ResponseMetrics metrics = ResponseMetrics.of(System.nanoTime() - elapsedStart, metadata.getJobDuration(), stats.getCount(), stats.getSize(), metadata.getProcessedObjects(), 0L, metadata.getTotalWarningsCount());
                printer.addFooterPrinter(new MetricsPrinter(metrics, HttpUtil.getPreferredCharset((IServletRequest)request)));
                if (metadata.getJobProfile() != null) {
                    printer.addFooterPrinter(new ProfilePrinter(metadata.getJobProfile()));
                }
                printer.printFooters();
                printer.end();
            } else {
                ResultUtil.printResults(this.appCtx, resultReader, sessionOutput, new IStatementExecutor.Stats(), null);
            }
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.NO_RESULT_SET)) {
                LOGGER.log(Level.INFO, "No results for: \"" + strHandle + "\"");
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                return;
            }
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            response.writer().println(e.getMessage());
            LOGGER.log(Level.WARN, "Error retrieving result for \"" + strHandle + "\"", (Throwable)e);
        }
        catch (Exception e) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            LOGGER.log(Level.WARN, "Error retrieving result for \"" + strHandle + "\"", (Throwable)e);
        }
        if (response.writer().checkError()) {
            LOGGER.warn("Error flushing output writer for \"" + strHandle + "\"");
        }
    }

    static SessionOutput initResponse(IServletRequest request, IServletResponse response, SessionConfig.OutputFormat format) throws IOException {
        String accept = request.getHeader((CharSequence)"Accept");
        if (accept == null) {
            accept = "";
        }
        SessionConfig.PlanFormat planFormat = SessionConfig.PlanFormat.get((String)request.getParameter((CharSequence)"plan-format"), (String)"plan format", (SessionConfig.PlanFormat)SessionConfig.PlanFormat.STRING, (Logger)LOGGER);
        SessionOutput.ResultAppender appendHandle = (app, handle) -> app.append((CharSequence)"{ \"").append((CharSequence)"handle").append((CharSequence)"\": \"").append((CharSequence)handle).append((CharSequence)"\" }");
        SessionConfig sessionConfig = new SessionConfig(format, planFormat);
        boolean wrapperArray = format == SessionConfig.OutputFormat.CLEAN_JSON || format == SessionConfig.OutputFormat.LOSSLESS_JSON;
        String wrapperParam = request.getParameter((CharSequence)"wrapper-array");
        if (wrapperParam != null) {
            wrapperArray = Boolean.valueOf(wrapperParam);
        } else if (accept.contains("wrap-array=true")) {
            wrapperArray = true;
        } else if (accept.contains("wrap-array=false")) {
            wrapperArray = false;
        }
        sessionConfig.set("format-wrapper-array", wrapperArray);
        SessionOutput.ResultDecorator resultPrefix = null;
        SessionOutput.ResultDecorator resultPostfix = null;
        switch (format) {
            case ADM: {
                HttpUtil.setContentType((IServletResponse)response, (String)"application/x-adm", (IServletRequest)request);
                break;
            }
            case CLEAN_JSON: 
            case LOSSLESS_JSON: {
                HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
                resultPrefix = ResultUtil.createPreResultDecorator();
                resultPostfix = ResultUtil.createPostResultDecorator();
                break;
            }
            case CSV: {
                if ("present".equals(request.getParameter((CharSequence)"header")) || accept.contains("header=present")) {
                    HttpUtil.setContentType((IServletResponse)response, (String)"text/csv; header=present", (IServletRequest)request);
                    sessionConfig.set("format-csv-header", true);
                    break;
                }
                HttpUtil.setContentType((IServletResponse)response, (String)"text/csv; header=absent", (IServletRequest)request);
                break;
            }
            default: {
                throw new IOException("Unknown format " + format);
            }
        }
        return new SessionOutput(sessionConfig, response.writer(), resultPrefix, resultPostfix, appendHandle, null);
    }
}

