/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.api.http.server.QueryServiceRequestParameters;
import org.apache.asterix.app.message.CancelQueryRequest;
import org.apache.asterix.app.message.CancelQueryResponse;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.common.utils.RequestStatus;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCQueryCancellationServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INCServiceContext serviceCtx;
    private final INCMessageBroker messageBroker;

    public NCQueryCancellationServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
        this.serviceCtx = (INCServiceContext)ctx.get("org.apache.asterix.SERVICE_CONTEXT");
        this.messageBroker = (INCMessageBroker)this.serviceCtx.getMessageBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delete(IServletRequest request, IServletResponse response) {
        String uuid = request.getParameter((CharSequence)"request_id");
        String clientContextId = request.getParameter((CharSequence)QueryServiceRequestParameters.Parameter.CLIENT_ID.str());
        if (uuid == null && clientContextId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        MessageFuture cancelQueryFuture = this.messageBroker.registerMessageFuture();
        try {
            CancelQueryRequest cancelQueryMessage = new CancelQueryRequest(this.serviceCtx.getNodeId(), cancelQueryFuture.getFutureId(), uuid, clientContextId);
            this.messageBroker.sendMessageToPrimaryCC((ICcAddressedMessage)cancelQueryMessage);
            CancelQueryResponse cancelResponse = (CancelQueryResponse)cancelQueryFuture.get(ExecuteStatementRequestMessage.DEFAULT_NC_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            RequestStatus status = cancelResponse.getStatus();
            switch (status) {
                case SUCCESS: 
                case FAILED: 
                case NOT_FOUND: 
                case REJECTED: {
                    response.setStatus(status.toHttpResponse());
                    return;
                }
                default: {
                    throw new IllegalStateException("Unrecognized status: " + status);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unexpected exception while canceling query", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        finally {
            this.messageBroker.deregisterMessageFuture(cancelQueryFuture.getFutureId());
        }
    }
}

