/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.net.URL;
import java.util.List;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.IJobSerializerDeserializerContainer;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;

public class DeployBinaryWork
extends AbstractWork {
    private final DeploymentId deploymentId;
    private final NodeControllerService ncs;
    private final List<URL> binaryURLs;
    private final CcId ccId;

    public DeployBinaryWork(NodeControllerService ncs, DeploymentId deploymentId, List<URL> binaryURLs, CcId ccId) {
        this.deploymentId = deploymentId;
        this.ncs = ncs;
        this.binaryURLs = binaryURLs;
        this.ccId = ccId;
    }

    public void run() {
        DeploymentStatus status;
        try {
            DeploymentUtils.deploy((DeploymentId)this.deploymentId, this.binaryURLs, (IJobSerializerDeserializerContainer)this.ncs.getContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ncs.getServerContext(), (boolean)true);
            status = DeploymentStatus.SUCCEED;
        }
        catch (Exception e) {
            status = DeploymentStatus.FAIL;
            e.printStackTrace();
        }
        try {
            IClusterController ccs = this.ncs.getClusterController(this.ccId);
            ccs.notifyDeployBinary(this.deploymentId, this.ncs.getId(), status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

