/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanBigList;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigList;
import it.unimi.dsi.fastutil.booleans.BooleanBigListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanBigListIterators;
import it.unimi.dsi.fastutil.booleans.BooleanBigSpliterators;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class BooleanBigArrayBigList
extends AbstractBooleanBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient boolean[][] a;
    protected long size;

    protected BooleanBigArrayBigList(boolean[][] a, boolean dummy) {
        this.a = a;
    }

    public BooleanBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0L ? BooleanBigArrays.EMPTY_BIG_ARRAY : BooleanBigArrays.newBigArray((long)capacity);
    }

    public BooleanBigArrayBigList() {
        this.a = BooleanBigArrays.DEFAULT_EMPTY_BIG_ARRAY;
    }

    public BooleanBigArrayBigList(BooleanCollection c) {
        this(Size64.sizeOf((Collection)c));
        if (c instanceof BooleanBigList) {
            this.size = Size64.sizeOf((Collection)c);
            ((BooleanBigList)c).getElements(0L, this.a, 0L, this.size);
        } else {
            BooleanIterator i = c.iterator();
            while (i.hasNext()) {
                this.add(i.nextBoolean());
            }
        }
    }

    public BooleanBigArrayBigList(BooleanBigList l) {
        this(l.size64());
        this.size = l.size64();
        l.getElements(0L, this.a, 0L, this.size);
    }

    public BooleanBigArrayBigList(boolean[][] a) {
        this(a, 0L, BigArrays.length((boolean[][])a));
    }

    public BooleanBigArrayBigList(boolean[][] a, long offset, long length) {
        this(length);
        BigArrays.copy((boolean[][])a, (long)offset, (boolean[][])this.a, (long)0L, (long)length);
        this.size = length;
    }

    public BooleanBigArrayBigList(Iterator<? extends Boolean> i) {
        this();
        while (i.hasNext()) {
            this.add((boolean)i.next());
        }
    }

    public BooleanBigArrayBigList(BooleanIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextBoolean());
        }
    }

    public boolean[][] elements() {
        return this.a;
    }

    public static BooleanBigArrayBigList wrap(boolean[][] a, long length) {
        if (length > BigArrays.length((boolean[][])a)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + BigArrays.length((boolean[][])a) + ")");
        }
        BooleanBigArrayBigList l = new BooleanBigArrayBigList(a, false);
        l.size = length;
        return l;
    }

    public static BooleanBigArrayBigList wrap(boolean[][] a) {
        return BooleanBigArrayBigList.wrap(a, BigArrays.length((boolean[][])a));
    }

    public static BooleanBigArrayBigList of() {
        return new BooleanBigArrayBigList();
    }

    public static BooleanBigArrayBigList of(boolean ... init) {
        return BooleanBigArrayBigList.wrap(BigArrays.wrap((boolean[])init));
    }

    public void ensureCapacity(long capacity) {
        if (capacity <= BigArrays.length((boolean[][])this.a) || this.a == BooleanBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            return;
        }
        this.a = BigArrays.forceCapacity((boolean[][])this.a, (long)capacity, (long)this.size);
        assert (this.size <= BigArrays.length((boolean[][])this.a));
    }

    private void grow(long capacity) {
        long oldLength = BigArrays.length((boolean[][])this.a);
        if (capacity <= oldLength) {
            return;
        }
        if (this.a != BooleanBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            capacity = Math.max(oldLength + (oldLength >> 1), capacity);
        } else if (capacity < 10L) {
            capacity = 10L;
        }
        this.a = BigArrays.forceCapacity((boolean[][])this.a, (long)capacity, (long)this.size);
        assert (this.size <= BigArrays.length((boolean[][])this.a));
    }

    @Override
    public void add(long index, boolean k) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            BigArrays.copy((boolean[][])this.a, (long)index, (boolean[][])this.a, (long)(index + 1L), (long)(this.size - index));
        }
        BigArrays.set((boolean[][])this.a, (long)index, (boolean)k);
        ++this.size;
        assert (this.size <= BigArrays.length((boolean[][])this.a));
    }

    @Override
    public boolean add(boolean k) {
        this.grow(this.size + 1L);
        BigArrays.set((boolean[][])this.a, (long)this.size++, (boolean)k);
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        return true;
    }

    @Override
    public boolean getBoolean(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return BigArrays.get((boolean[][])this.a, (long)index);
    }

    @Override
    public long indexOf(boolean k) {
        for (long i = 0L; i < this.size; ++i) {
            if (k != BigArrays.get((boolean[][])this.a, (long)i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(boolean k) {
        long i = this.size;
        while (i-- != 0L) {
            if (k != BigArrays.get((boolean[][])this.a, (long)i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public boolean removeBoolean(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        boolean old = BigArrays.get((boolean[][])this.a, (long)index);
        --this.size;
        if (index != this.size) {
            BigArrays.copy((boolean[][])this.a, (long)(index + 1L), (boolean[][])this.a, (long)index, (long)(this.size - index));
        }
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        return old;
    }

    @Override
    public boolean rem(boolean k) {
        long index = this.indexOf(k);
        if (index == -1L) {
            return false;
        }
        this.removeBoolean(index);
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        return true;
    }

    @Override
    public boolean set(long index, boolean k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        boolean old = BigArrays.get((boolean[][])this.a, (long)index);
        BigArrays.set((boolean[][])this.a, (long)index, (boolean)k);
        return old;
    }

    @Override
    public boolean removeAll(BooleanCollection c) {
        boolean[] s = null;
        boolean[] d = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i = 0L; i < this.size; ++i) {
            if (sd == 0x8000000) {
                sd = 0;
                s = this.a[++ss];
            }
            if (!c.contains((boolean)s[sd])) {
                if (dd == 0x8000000) {
                    d = this.a[++ds];
                    dd = 0;
                }
                d[dd++] = s[sd];
            }
            ++sd;
        }
        long j = BigArrays.index((int)ds, (int)dd);
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean[] s = null;
        boolean[] d = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i = 0L; i < this.size; ++i) {
            if (sd == 0x8000000) {
                sd = 0;
                s = this.a[++ss];
            }
            if (!c.contains((boolean)s[sd])) {
                if (dd == 0x8000000) {
                    d = this.a[++ds];
                    dd = 0;
                }
                d[dd++] = s[sd];
            }
            ++sd;
        }
        long j = BigArrays.index((int)ds, (int)dd);
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public boolean addAll(long index, BooleanCollection c) {
        if (c instanceof BooleanList) {
            return this.addAll(index, (BooleanList)c);
        }
        if (c instanceof BooleanBigList) {
            return this.addAll(index, (BooleanBigList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + (long)n);
        BigArrays.copy((boolean[][])this.a, (long)index, (boolean[][])this.a, (long)(index + (long)n), (long)(this.size - index));
        BooleanIterator i = c.iterator();
        this.size += (long)n;
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        while (n-- != 0) {
            BigArrays.set((boolean[][])this.a, (long)index++, (boolean)i.nextBoolean());
        }
        return true;
    }

    @Override
    public boolean addAll(long index, BooleanBigList list) {
        this.ensureIndex(index);
        long n = list.size64();
        if (n == 0L) {
            return false;
        }
        this.grow(this.size + n);
        BigArrays.copy((boolean[][])this.a, (long)index, (boolean[][])this.a, (long)(index + n), (long)(this.size - index));
        list.getElements(0L, this.a, index, n);
        this.size += n;
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        return true;
    }

    @Override
    public boolean addAll(long index, BooleanList list) {
        int l;
        int n;
        this.ensureIndex(index);
        if (n == 0) {
            return false;
        }
        this.grow(this.size + (long)n);
        BigArrays.copy((boolean[][])this.a, (long)index, (boolean[][])this.a, (long)(index + (long)n), (long)(this.size - index));
        this.size += (long)n;
        assert (this.size <= BigArrays.length((boolean[][])this.a));
        int segment = BigArrays.segment((long)index);
        int displ = BigArrays.displacement((long)index);
        int pos = 0;
        for (n = list.size(); n > 0; n -= l) {
            l = Math.min(this.a[segment].length - displ, n);
            list.getElements(pos, this.a[segment], displ, l);
            if ((displ += l) == 0x8000000) {
                displ = 0;
                ++segment;
            }
            pos += l;
        }
        return true;
    }

    @Override
    public void clear() {
        this.size = 0L;
        assert (this.size <= BigArrays.length((boolean[][])this.a));
    }

    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > BigArrays.length((boolean[][])this.a)) {
            this.a = BigArrays.forceCapacity((boolean[][])this.a, (long)size, (long)this.size);
        }
        if (size > this.size) {
            BigArrays.fill((boolean[][])this.a, (long)this.size, (long)size, (boolean)false);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n) {
        long arrayLength = BigArrays.length((boolean[][])this.a);
        if (n >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = BigArrays.trim((boolean[][])this.a, (long)Math.max(n, this.size));
        assert (this.size <= BigArrays.length((boolean[][])this.a));
    }

    @Override
    public BooleanBigList subList(long from, long to) {
        if (from == 0L && to == this.size64()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new SubList(from, to);
    }

    @Override
    public void getElements(long from, boolean[][] a, long offset, long length) {
        BigArrays.copy((boolean[][])this.a, (long)from, (boolean[][])a, (long)offset, (long)length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo((long)this.size, (long)from, (long)to);
        BigArrays.copy((boolean[][])this.a, (long)to, (boolean[][])this.a, (long)from, (long)(this.size - to));
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, boolean[][] a, long offset, long length) {
        this.ensureIndex(index);
        BigArrays.ensureOffsetLength((boolean[][])a, (long)offset, (long)length);
        this.grow(this.size + length);
        BigArrays.copy((boolean[][])this.a, (long)index, (boolean[][])this.a, (long)(index + length), (long)(this.size - index));
        BigArrays.copy((boolean[][])a, (long)offset, (boolean[][])this.a, (long)index, (long)length);
        this.size += length;
    }

    @Override
    public void setElements(long index, boolean[][] a, long offset, long length) {
        BigArrays.copy((boolean[][])a, (long)offset, (boolean[][])this.a, (long)index, (long)length);
    }

    @Override
    public void forEach(BooleanConsumer action) {
        for (long i = 0L; i < this.size; ++i) {
            action.accept(BigArrays.get((boolean[][])this.a, (long)i));
        }
    }

    @Override
    public BooleanBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new BooleanBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            public boolean hasNext() {
                return this.pos < BooleanBigArrayBigList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.last);
            }

            @Override
            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.pos);
            }

            public long nextIndex() {
                return this.pos;
            }

            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(boolean k) {
                BooleanBigArrayBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(boolean k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                BooleanBigArrayBigList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                BooleanBigArrayBigList.this.removeBoolean(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }

            public void forEachRemaining(BooleanConsumer action) {
                while (this.pos < BooleanBigArrayBigList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.last));
                }
            }

            @Override
            public long back(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                long remaining = BooleanBigArrayBigList.this.size - this.pos;
                if (n < remaining) {
                    this.pos -= n;
                } else {
                    n = remaining;
                    this.pos = 0L;
                }
                this.last = this.pos;
                return n;
            }

            @Override
            public long skip(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                long remaining = BooleanBigArrayBigList.this.size - this.pos;
                if (n < remaining) {
                    this.pos += n;
                } else {
                    n = remaining;
                    this.pos = BooleanBigArrayBigList.this.size;
                }
                this.last = this.pos - 1L;
                return n;
            }
        };
    }

    @Override
    public BooleanSpliterator spliterator() {
        return new Spliterator();
    }

    public BooleanBigArrayBigList clone() {
        BooleanBigArrayBigList c;
        if (this.getClass() == BooleanBigArrayBigList.class) {
            c = new BooleanBigArrayBigList(this.size);
            c.size = this.size;
        } else {
            try {
                c = (BooleanBigArrayBigList)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
            c.a = BooleanBigArrays.newBigArray((long)this.size);
        }
        BigArrays.copy((boolean[][])this.a, (long)0L, (boolean[][])c.a, (long)0L, (long)this.size);
        return c;
    }

    public boolean equals(BooleanBigArrayBigList l) {
        if (l == this) {
            return true;
        }
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        boolean[][] a1 = this.a;
        boolean[][] a2 = l.a;
        if (a1 == a2) {
            return true;
        }
        while (s-- != 0L) {
            if (BigArrays.get((boolean[][])a1, (long)s) == BigArrays.get((boolean[][])a2, (long)s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        if (o instanceof BooleanBigArrayBigList) {
            return this.equals((BooleanBigArrayBigList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(BooleanBigArrayBigList l) {
        long s1 = this.size64();
        long s2 = l.size64();
        boolean[][] a1 = this.a;
        boolean[][] a2 = l.a;
        if (a1 == a2 && s1 == s2) {
            return 0;
        }
        int i = 0;
        while ((long)i < s1 && (long)i < s2) {
            boolean e2;
            boolean e1 = BigArrays.get((boolean[][])a1, (long)i);
            int r = Boolean.compare(e1, e2 = BigArrays.get((boolean[][])a2, (long)i));
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return (long)i < s2 ? -1 : ((long)i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(BigList<? extends Boolean> l) {
        if (l instanceof BooleanBigArrayBigList) {
            return this.compareTo((BooleanBigArrayBigList)l);
        }
        if (l instanceof SubList) {
            return -((SubList)l).compareTo(this);
        }
        return super.compareTo(l);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = 0;
        while ((long)i < this.size) {
            s.writeBoolean(BigArrays.get((boolean[][])this.a, (long)i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = BooleanBigArrays.newBigArray((long)this.size);
        int i = 0;
        while ((long)i < this.size) {
            BigArrays.set((boolean[][])this.a, (long)i, (boolean)s.readBoolean());
            ++i;
        }
    }

    private class SubList
    extends AbstractBooleanBigList.BooleanRandomAccessSubList {
        private static final long serialVersionUID = -3185226345314976296L;

        protected SubList(long from, long to) {
            super(BooleanBigArrayBigList.this, from, to);
        }

        private boolean[][] getParentArray() {
            return BooleanBigArrayBigList.this.a;
        }

        @Override
        public boolean getBoolean(long i) {
            this.ensureRestrictedIndex(i);
            return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)(i + this.from));
        }

        @Override
        public BooleanBigListIterator listIterator(long index) {
            return new SubListIterator(index);
        }

        @Override
        public BooleanSpliterator spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(boolean[][] otherA, long otherAFrom, long otherATo) {
            if (BooleanBigArrayBigList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size64()) {
                return false;
            }
            long pos = this.to;
            long otherPos = otherATo;
            while (--pos >= this.from) {
                if (BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)pos) == BigArrays.get((boolean[][])otherA, (long)(--otherPos))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof BigList)) {
                return false;
            }
            if (o instanceof BooleanBigArrayBigList) {
                BooleanBigArrayBigList other = (BooleanBigArrayBigList)o;
                return this.contentsEquals(other.a, 0L, other.size64());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        int contentsCompareTo(boolean[][] otherA, long otherAFrom, long otherATo) {
            if (BooleanBigArrayBigList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return 0;
            }
            long i = this.from;
            long j = otherAFrom;
            while (i < this.to && i < otherATo) {
                boolean e2;
                boolean e1 = BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)i);
                int r = Boolean.compare(e1, e2 = BigArrays.get((boolean[][])otherA, (long)j));
                if (r != 0) {
                    return r;
                }
                ++i;
                ++j;
            }
            return i < otherATo ? -1 : (i < this.to ? 1 : 0);
        }

        @Override
        public int compareTo(BigList<? extends Boolean> l) {
            if (l instanceof BooleanBigArrayBigList) {
                BooleanBigArrayBigList other = (BooleanBigArrayBigList)l;
                return this.contentsCompareTo(other.a, 0L, other.size64());
            }
            if (l instanceof SubList) {
                SubList other = (SubList)l;
                return this.contentsCompareTo(other.getParentArray(), other.from, other.to);
            }
            return super.compareTo(l);
        }

        private final class SubListIterator
        extends BooleanBigListIterators.AbstractIndexBasedBigListIterator {
            SubListIterator(long index) {
                super(0L, index);
            }

            @Override
            protected final boolean get(long i) {
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)(SubList.this.from + i));
            }

            @Override
            protected final void add(long i, boolean k) {
                SubList.this.add(i, k);
            }

            @Override
            protected final void set(long i, boolean k) {
                SubList.this.set(i, k);
            }

            @Override
            protected final void remove(long i) {
                SubList.this.removeBoolean(i);
            }

            @Override
            protected final long getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            @Override
            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)(SubList.this.from + this.lastReturned));
            }

            @Override
            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)(SubList.this.from + this.pos));
            }

            @Override
            public void forEachRemaining(BooleanConsumer action) {
                long max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)(SubList.this.from + this.lastReturned)));
                }
            }
        }

        private final class SubListSpliterator
        extends BooleanBigSpliterators.LateBindingSizeIndexBasedSpliterator {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(long pos, long maxPos) {
                super(pos, maxPos);
            }

            @Override
            protected final long getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            @Override
            protected final boolean get(long i) {
                return BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)i);
            }

            @Override
            protected final SubListSpliterator makeForSplit(long pos, long maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            @Override
            protected final long computeSplitPoint() {
                long defaultSplit = super.computeSplitPoint();
                return BigArrays.nearestSegmentStart((long)defaultSplit, (long)(this.pos + 1L), (long)(this.getMaxPos() - 1L));
            }

            @Override
            public boolean tryAdvance(BooleanConsumer action) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.pos++));
                return true;
            }

            @Override
            public void forEachRemaining(BooleanConsumer action) {
                long max = this.getMaxPos();
                while (this.pos < max) {
                    action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.pos++));
                }
            }
        }
    }

    private final class Spliterator
    implements BooleanSpliterator {
        boolean hasSplit = false;
        long pos;
        long max;

        public Spliterator() {
            this(0L, booleanBigArrayBigList.size, false);
        }

        private Spliterator(long pos, long max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private long getWorkingMax() {
            return this.hasSplit ? this.max : BooleanBigArrayBigList.this.size;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(BooleanConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(BooleanConsumer action) {
            long max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(BigArrays.get((boolean[][])BooleanBigArrayBigList.this.a, (long)this.pos));
                ++this.pos;
            }
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            long max = this.getWorkingMax();
            if (this.pos >= max) {
                return 0L;
            }
            long remaining = max - this.pos;
            if (n < remaining) {
                this.pos += n;
                return n;
            }
            n = remaining;
            this.pos = max;
            return n;
        }

        @Override
        public BooleanSpliterator trySplit() {
            long max = this.getWorkingMax();
            long retLen = max - this.pos >> 1;
            if (retLen <= 1L) {
                return null;
            }
            this.max = max;
            long myNewPos = this.pos + retLen;
            long retMax = myNewPos = BigArrays.nearestSegmentStart((long)myNewPos, (long)(this.pos + 1L), (long)(max - 1L));
            long oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

