/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HoursDistribution {
    private static final int NUM_WEIGHT_FIELDS = Weights.values().length;
    private static final String VALUES_AND_WEIGHTS_FILENAME = "hours.dst";
    private static final HoursDistribution HOURS_DISTRIBUTION = HoursDistribution.buildHoursDistribution();
    private final ImmutableList<Integer> hours;
    private final ImmutableList<String> amPm;
    private final ImmutableList<String> shifts;
    private final ImmutableList<String> subShifts;
    private final ImmutableList<String> meals;
    private final ImmutableList<ImmutableList<Integer>> weightsLists;

    public HoursDistribution(ImmutableList<Integer> hours, ImmutableList<String> amPm, ImmutableList<String> shifts, ImmutableList<String> subShifts, ImmutableList<String> meals, ImmutableList<ImmutableList<Integer>> weightsLists) {
        this.hours = hours;
        this.amPm = amPm;
        this.shifts = shifts;
        this.subShifts = subShifts;
        this.meals = meals;
        this.weightsLists = weightsLists;
    }

    private static HoursDistribution buildHoursDistribution() {
        ImmutableList.Builder hoursBuilder = ImmutableList.builder();
        ImmutableList.Builder amPmBuilder = ImmutableList.builder();
        ImmutableList.Builder shiftsBuilder = ImmutableList.builder();
        ImmutableList.Builder subShiftsBuilder = ImmutableList.builder();
        ImmutableList.Builder mealsBuilder = ImmutableList.builder();
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(NUM_WEIGHT_FIELDS);
        for (int i = 0; i < NUM_WEIGHT_FIELDS; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(VALUES_AND_WEIGHTS_FILENAME);
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == 5 ? 1 : 0) != 0, (String)"Expected line to contain 5 values, but it contained %d, %s", (Object[])new Object[]{values.size(), values});
            hoursBuilder.add((Object)Integer.parseInt(values.get(0)));
            amPmBuilder.add((Object)values.get(1));
            shiftsBuilder.add((Object)values.get(2));
            subShiftsBuilder.add((Object)values.get(3));
            mealsBuilder.add((Object)values.get(4));
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == NUM_WEIGHT_FIELDS ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object[])new Object[]{NUM_WEIGHT_FIELDS, weights.size(), values});
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.valueOf(weights.get(i)));
            }
        }
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        return new HoursDistribution((ImmutableList<Integer>)hoursBuilder.build(), (ImmutableList<String>)amPmBuilder.build(), (ImmutableList<String>)shiftsBuilder.build(), (ImmutableList<String>)subShiftsBuilder.build(), (ImmutableList<String>)mealsBuilder.build(), (ImmutableList<ImmutableList<Integer>>)weightsListBuilder.build());
    }

    public static int pickRandomHour(Weights weights, RandomNumberStream randomNumberStream) {
        return DistributionUtils.pickRandomValue(HoursDistribution.HOURS_DISTRIBUTION.hours, (List)HoursDistribution.HOURS_DISTRIBUTION.weightsLists.get(weights.ordinal()), randomNumberStream);
    }

    public static HourInfo getHourInfoForHour(int hour) {
        return new HourInfo((String)HoursDistribution.HOURS_DISTRIBUTION.amPm.get(hour), (String)HoursDistribution.HOURS_DISTRIBUTION.shifts.get(hour), (String)HoursDistribution.HOURS_DISTRIBUTION.subShifts.get(hour), (String)HoursDistribution.HOURS_DISTRIBUTION.meals.get(hour));
    }

    public static enum Weights {
        UNIFORM,
        STORE,
        CATALOG_AND_WEB;

    }

    public static class HourInfo {
        private final String amPm;
        private final String shift;
        private final String subShift;
        private final String meal;

        public HourInfo(String amPm, String shift, String subShift, String meal) {
            this.amPm = amPm;
            this.shift = shift;
            this.subShift = subShift;
            this.meal = meal;
        }

        public String getAmPm() {
            return this.amPm;
        }

        public String getShift() {
            return this.shift;
        }

        public String getSubShift() {
            return this.subShift;
        }

        public String getMeal() {
            return this.meal;
        }
    }
}

