/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;

public class RPCInterface
implements IIPCI {
    private final Map<Long, Request> reqMap = new HashMap<Long, Request>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(IIPCHandle handle, Object request) throws Exception {
        Request req;
        Map<Long, Request> map = this.reqMap;
        synchronized (map) {
            req = new Request(handle, this);
            long mid = handle.send(-1L, request, null);
            this.reqMap.put(mid, req);
        }
        return req.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload) {
        Request req;
        Map<Long, Request> map = this.reqMap;
        synchronized (map) {
            req = this.reqMap.remove(rmid);
        }
        assert (req != null);
        req.setResult(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        Request req;
        Map<Long, Request> map = this.reqMap;
        synchronized (map) {
            req = this.reqMap.remove(rmid);
        }
        assert (req != null);
        req.setException(exception);
    }

    private static class Request {
        private boolean pending = true;
        private Object result = null;
        private Exception exception = null;

        Request(IIPCHandle carrier, RPCInterface parent) {
        }

        synchronized void setResult(Object result) {
            this.pending = false;
            this.result = result;
            this.notifyAll();
        }

        synchronized void setException(Exception exception) {
            this.pending = false;
            this.exception = exception;
            this.notifyAll();
        }

        synchronized Object getResponse() throws Exception {
            while (this.pending) {
                this.wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

