/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.asterix.common.storage.DatasetResourceReference;

public class ResourceStorageStats {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final DatasetResourceReference ref;
    private final Map<String, Long> components;
    private final long totalSize;

    public ResourceStorageStats(DatasetResourceReference ref, Map<String, Long> components, long totalSize) {
        this.ref = ref;
        this.components = components;
        this.totalSize = totalSize;
    }

    public DatasetResourceReference getRef() {
        return this.ref;
    }

    public Map<String, Long> getComponents() {
        return this.components;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public JsonNode asJson() {
        ObjectNode json = OBJECT_MAPPER.createObjectNode();
        json.put("index", this.ref.getIndex());
        json.put("dataset", this.ref.getDataset());
        json.put("datasetId", this.ref.getDatasetId());
        json.put("partition", this.ref.getPartitionId());
        json.put("path", this.ref.getRelativePath().toString());
        json.put("totalSize", this.totalSize);
        ArrayNode componentsJson = OBJECT_MAPPER.createArrayNode();
        this.components.forEach((id, size) -> {
            ObjectNode component = OBJECT_MAPPER.createObjectNode();
            component.put("id", id);
            component.put("size", size);
            componentsJson.add((JsonNode)component);
        });
        json.set("components", (JsonNode)componentsJson);
        return json;
    }
}

