/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.AbstractAccessor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class ListSliceExpression
extends AbstractAccessor {
    private Expression startIndexExpression;
    private Expression endIndexExpression;

    public ListSliceExpression(Expression expr, Expression startIndexExpression, Expression endIndexExpression) {
        super(expr);
        this.startIndexExpression = startIndexExpression;
        this.endIndexExpression = endIndexExpression;
    }

    public Expression getStartIndexExpression() {
        return this.startIndexExpression;
    }

    public Expression getEndIndexExpression() {
        return this.endIndexExpression;
    }

    public boolean hasEndExpression() {
        return this.endIndexExpression != null;
    }

    public void setStartIndexExpression(Expression startIndexExpression) {
        this.startIndexExpression = startIndexExpression;
    }

    public void setEndIndexExpression(Expression endIndexExpression) {
        this.endIndexExpression = endIndexExpression;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.LIST_SLICE_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expr, this.startIndexExpression, this.endIndexExpression);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ListSliceExpression)) {
            return false;
        }
        ListSliceExpression target = (ListSliceExpression)object;
        return super.equals(target) && Objects.equals(this.startIndexExpression, target.startIndexExpression) && Objects.equals(this.endIndexExpression, target.endIndexExpression);
    }

    public String toString() {
        return this.expr + "[" + this.startIndexExpression + ":" + (this.hasEndExpression() ? this.endIndexExpression : "") + "]";
    }
}

