/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import java.io.IOException;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.UTF8WordToken;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class HashedUTF8WordToken
extends UTF8WordToken {
    private int hash = 0;

    public HashedUTF8WordToken(byte tokenTypeTag, byte countTypeTag) {
        super(tokenTypeTag, countTypeTag);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IToken)) {
            return false;
        }
        IToken t = (IToken)o;
        if (t.getTokenLength() != this.tokenLength) {
            return false;
        }
        int offset = 0;
        for (int i = 0; i < this.tokenLength; ++i) {
            if (UTF8StringUtil.charAt((byte[])t.getData(), (int)(t.getStartOffset() + offset)) != UTF8StringUtil.charAt((byte[])this.data, (int)(this.startOffset + offset))) {
                return false;
            }
            offset += UTF8StringUtil.charSize((byte[])this.data, (int)(this.startOffset + offset));
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public void reset(byte[] data, int startOffset, int endOffset, int tokenLength, int tokenCount) {
        super.reset(data, startOffset, endOffset, tokenLength, tokenCount);
        int pos = startOffset;
        this.hash = -1640531527;
        for (int i = 0; i < tokenLength; ++i) {
            this.hash ^= Character.toLowerCase(UTF8StringUtil.charAt((byte[])data, (int)pos));
            this.hash *= -1640531527;
            pos += UTF8StringUtil.charSize((byte[])data, (int)pos);
        }
        this.hash += tokenCount;
    }

    @Override
    public void serializeToken(GrowableArray out) throws IOException {
        if (this.tokenTypeTag > 0) {
            out.getDataOutput().write(this.tokenTypeTag);
        }
        out.getDataOutput().writeInt(this.hash);
    }
}

