/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.ByteArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractForwardOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class SortForwardOperatorDescriptor
extends AbstractForwardOperatorDescriptor {
    private static final long serialVersionUID = 1L;

    public SortForwardOperatorDescriptor(IOperatorDescriptorRegistry spec, String sideDataKey, RecordDescriptor outputRecordDescriptor) {
        super(spec, sideDataKey, outputRecordDescriptor);
    }

    @Override
    public AbstractActivityNode createForwardDataActivity() {
        return new ForwardDataActivity(new ActivityId(this.odId, 0));
    }

    @Override
    public AbstractActivityNode createSideDataActivity() {
        return new RangeMapReaderActivity(new ActivityId(this.odId, 1));
    }

    private class ForwardDataActivityNodePushable
    extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
        private final IHyracksTaskContext ctx;
        private final int partition;

        private ForwardDataActivityNodePushable(IHyracksTaskContext ctx, int partition) {
            this.ctx = ctx;
            this.partition = partition;
        }

        public void open() throws HyracksDataException {
            TaskId stateObjKey = new TaskId(new ActivityId(SortForwardOperatorDescriptor.this.odId, 1), this.partition);
            RangeMapState rangeMapState = (RangeMapState)this.ctx.getStateObject((Object)stateObjKey);
            TaskUtil.put((String)SortForwardOperatorDescriptor.this.sideDataKey, (Object)rangeMapState.rangeMap, (IHyracksTaskContext)this.ctx);
            this.writer.open();
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.writer.nextFrame(buffer);
        }

        public void fail() throws HyracksDataException {
            this.writer.fail();
        }

        public void close() throws HyracksDataException {
            this.writer.close();
        }

        public void flush() throws HyracksDataException {
            this.writer.flush();
        }
    }

    private class RangeMapReaderActivityNodePushable
    extends AbstractUnaryInputSinkOperatorNodePushable {
        private final FrameTupleAccessor frameTupleAccessor;
        private final FrameTupleReference frameTupleReference;
        private final IHyracksTaskContext ctx;
        private final ActivityId activityId;
        private final int partition;
        private int numFields;
        private byte[] splitValues;
        private int[] splitValuesEndOffsets;
        private double[] percentages;

        private RangeMapReaderActivityNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecordDescriptor, ActivityId activityId, int partition) {
            this.ctx = ctx;
            this.frameTupleAccessor = new FrameTupleAccessor(inputRecordDescriptor);
            this.frameTupleReference = new FrameTupleReference();
            this.activityId = activityId;
            this.partition = partition;
            this.numFields = -1;
        }

        public void open() throws HyracksDataException {
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.frameTupleAccessor.reset(buffer);
            if (this.frameTupleAccessor.getTupleCount() != 1) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.ONE_TUPLE_RANGEMAP_EXPECTED, (SourceLocation)SortForwardOperatorDescriptor.this.sourceLoc, (Serializable[])new Serializable[0]);
            }
            this.frameTupleReference.reset((IFrameTupleAccessor)this.frameTupleAccessor, 0);
            byte[] rangeMap = this.frameTupleReference.getFieldData(0);
            int offset = this.frameTupleReference.getFieldStart(0);
            int length = this.frameTupleReference.getFieldLength(0);
            ByteArrayPointable pointable = new ByteArrayPointable();
            pointable.set(rangeMap, offset + 1, length - 1);
            ByteArrayInputStream rangeMapIn = new ByteArrayInputStream(pointable.getByteArray(), pointable.getContentStartOffset(), pointable.getContentLength());
            DataInputStream dataInputStream = new DataInputStream(rangeMapIn);
            this.numFields = IntegerSerializerDeserializer.read((DataInput)dataInputStream);
            this.splitValues = ByteArraySerializerDeserializer.read((DataInput)dataInputStream);
            this.splitValuesEndOffsets = IntArraySerializerDeserializer.read((DataInput)dataInputStream);
            this.percentages = DoubleArraySerializerDeserializer.read((DataInput)dataInputStream);
        }

        public void fail() throws HyracksDataException {
        }

        public void close() throws HyracksDataException {
            if (this.numFields <= 0 || this.splitValues == null || this.splitValuesEndOffsets == null) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.NO_RANGEMAP_PRODUCED, (SourceLocation)SortForwardOperatorDescriptor.this.sourceLoc, (Serializable[])new Serializable[0]);
            }
            TaskId rangeMapReaderTaskId = new TaskId(this.activityId, this.partition);
            RangeMapState rangeMapState = new RangeMapState(this.ctx.getJobletContext().getJobId(), rangeMapReaderTaskId);
            rangeMapState.rangeMap = new RangeMap(this.numFields, this.splitValues, this.splitValuesEndOffsets, this.percentages);
            this.ctx.setStateObject((IStateObject)rangeMapState);
        }
    }

    private class ForwardDataActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        private ForwardDataActivity(ActivityId activityId) {
            super(activityId);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new ForwardDataActivityNodePushable(ctx, partition);
        }
    }

    private class RangeMapReaderActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        private RangeMapReaderActivity(ActivityId activityId) {
            super(activityId);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            RecordDescriptor inputRecordDescriptor = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            return new RangeMapReaderActivityNodePushable(ctx, inputRecordDescriptor, this.getActivityId(), partition);
        }
    }

    private class RangeMapState
    extends AbstractStateObject {
        RangeMap rangeMap;

        private RangeMapState(JobId jobId, TaskId stateObjectKey) {
            super(jobId, stateObjectKey);
        }
    }
}

