/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;

public class NestedLoopJoin {
    private static final int MIN_FRAME_BUDGET_INNER_JOIN = 3;
    private static final int MIN_FRAME_BUDGET_OUTER_JOIN = 4;
    private static final int ESTIMATE_AVG_TUPLE_SIZE = 128;
    private final FrameTupleAccessor accessorInner;
    private final FrameTupleAccessor accessorOuter;
    private final FrameTupleAppender appender;
    private ITuplePairComparator tpComparator;
    private final IFrame outBuffer;
    private final IFrame innerBuffer;
    private final VariableFrameMemoryManager outerBufferMngr;
    private final RunFileWriter runFileWriter;
    private final boolean isLeftOuter;
    private final ArrayTupleBuilder missingTupleBuilder;
    private final IPredicateEvaluator predEvaluator;
    private final boolean isReversed;
    private final BufferInfo tempInfo = new BufferInfo(null, -1, -1);
    private final BitSet outerMatchLOJ;

    public NestedLoopJoin(IHyracksJobletContext jobletContext, FrameTupleAccessor accessorOuter, FrameTupleAccessor accessorInner, int memBudgetInFrames, IPredicateEvaluator predEval, boolean isLeftOuter, IMissingWriter[] missingWriters) throws HyracksDataException {
        this(jobletContext, accessorOuter, accessorInner, memBudgetInFrames, predEval, isLeftOuter, missingWriters, false);
    }

    public NestedLoopJoin(IHyracksJobletContext jobletContext, FrameTupleAccessor accessorOuter, FrameTupleAccessor accessorInner, int memBudgetInFrames, IPredicateEvaluator predEval, boolean isLeftOuter, IMissingWriter[] missingWriters, boolean isReversed) throws HyracksDataException {
        int minMemBudgetInFrames;
        this.accessorInner = accessorInner;
        this.accessorOuter = accessorOuter;
        this.appender = new FrameTupleAppender();
        this.outBuffer = new VSizeFrame((IHyracksFrameMgrContext)jobletContext);
        this.innerBuffer = new VSizeFrame((IHyracksFrameMgrContext)jobletContext);
        this.appender.reset(this.outBuffer, true);
        int n = minMemBudgetInFrames = isLeftOuter ? 4 : 3;
        if (memBudgetInFrames < minMemBudgetInFrames) {
            throw new HyracksDataException(ErrorCode.INSUFFICIENT_MEMORY, new Serializable[0]);
        }
        int outerBufferMngrMemBudgetInFrames = memBudgetInFrames - minMemBudgetInFrames + 1;
        int outerBufferMngrMemBudgetInBytes = jobletContext.getInitialFrameSize() * outerBufferMngrMemBudgetInFrames;
        this.outerBufferMngr = new VariableFrameMemoryManager(new VariableFramePool((IHyracksFrameMgrContext)jobletContext, outerBufferMngrMemBudgetInBytes), FrameFreeSlotPolicyFactory.createFreeSlotPolicy(EnumFreeSlotPolicy.LAST_FIT, outerBufferMngrMemBudgetInFrames));
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        if (isLeftOuter) {
            if (isReversed) {
                throw new HyracksDataException(ErrorCode.ILLEGAL_STATE, new Serializable[]{"Outer join cannot reverse roles"});
            }
            int innerFieldCount = this.accessorInner.getFieldCount();
            this.missingTupleBuilder = new ArrayTupleBuilder(innerFieldCount);
            DataOutput out = this.missingTupleBuilder.getDataOutput();
            for (int i = 0; i < innerFieldCount; ++i) {
                missingWriters[i].writeMissing(out);
                this.missingTupleBuilder.addFieldEndOffset();
            }
            int outerMatchLOJCardinalityEstimate = outerBufferMngrMemBudgetInBytes / 128;
            this.outerMatchLOJ = new BitSet(Math.max(outerMatchLOJCardinalityEstimate, 1));
        } else {
            this.missingTupleBuilder = null;
            this.outerMatchLOJ = null;
        }
        this.isReversed = isReversed;
        FileReference file = jobletContext.createManagedWorkspaceFile(this.getClass().getSimpleName() + this.toString());
        this.runFileWriter = new RunFileWriter(file, jobletContext.getIoManager());
        this.runFileWriter.open();
    }

    public void cache(ByteBuffer buffer) throws HyracksDataException {
        this.accessorInner.reset(buffer);
        if (this.accessorInner.getTupleCount() > 0) {
            this.runFileWriter.nextFrame(buffer);
        }
    }

    void setComparator(ITuplePairComparator comparator) {
        this.tpComparator = comparator;
    }

    public void join(ByteBuffer outerBuffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorOuter.reset(outerBuffer);
        if (this.accessorOuter.getTupleCount() <= 0) {
            return;
        }
        if (this.outerBufferMngr.insertFrame(outerBuffer) < 0) {
            this.multiBlockJoin(writer);
            this.outerBufferMngr.reset();
            if (this.outerBufferMngr.insertFrame(outerBuffer) < 0) {
                throw new HyracksDataException("The given outer frame of size:" + outerBuffer.capacity() + " is too big to cache in the buffer. Please choose a larger buffer memory size");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multiBlockJoin(IFrameWriter writer) throws HyracksDataException {
        int outerBufferFrameCount = this.outerBufferMngr.getNumFrames();
        if (outerBufferFrameCount == 0) {
            return;
        }
        try (GeneratedRunFileReader runFileReader = this.runFileWriter.createReader();){
            BufferInfo outerBufferInfo;
            int i;
            int outerTupleRunningCount;
            runFileReader.open();
            if (this.isLeftOuter) {
                this.outerMatchLOJ.clear();
            }
            while (runFileReader.nextFrame(this.innerBuffer)) {
                outerTupleRunningCount = 0;
                for (i = 0; i < outerBufferFrameCount; ++i) {
                    outerBufferInfo = this.outerBufferMngr.getFrame(i, this.tempInfo);
                    this.accessorOuter.reset(outerBufferInfo.getBuffer(), outerBufferInfo.getStartOffset(), outerBufferInfo.getLength());
                    int outerTupleCount = this.accessorOuter.getTupleCount();
                    this.accessorInner.reset(this.innerBuffer.getBuffer());
                    this.blockJoin(outerTupleRunningCount, writer);
                    outerTupleRunningCount += outerTupleCount;
                }
            }
            if (this.isLeftOuter) {
                outerTupleRunningCount = 0;
                for (i = 0; i < outerBufferFrameCount; ++i) {
                    outerBufferInfo = this.outerBufferMngr.getFrame(i, this.tempInfo);
                    this.accessorOuter.reset(outerBufferInfo.getBuffer(), outerBufferInfo.getStartOffset(), outerBufferInfo.getLength());
                    int outerFrameTupleCount = this.accessorOuter.getTupleCount();
                    this.appendMissing(outerTupleRunningCount, outerFrameTupleCount, writer);
                    outerTupleRunningCount += outerFrameTupleCount;
                }
            }
        }
    }

    private void blockJoin(int outerTupleStartPos, IFrameWriter writer) throws HyracksDataException {
        int outerTupleCount = this.accessorOuter.getTupleCount();
        int innerTupleCount = this.accessorInner.getTupleCount();
        for (int i = 0; i < outerTupleCount; ++i) {
            boolean matchFound = false;
            for (int j = 0; j < innerTupleCount; ++j) {
                int c = this.tpComparator.compare((IFrameTupleAccessor)this.accessorOuter, i, (IFrameTupleAccessor)this.accessorInner, j);
                boolean prdEval = this.evaluatePredicate(i, j);
                if (c != 0 || !prdEval) continue;
                matchFound = true;
                this.appendToResults(i, j, writer);
            }
            if (!this.isLeftOuter || !matchFound) continue;
            this.outerMatchLOJ.set(outerTupleStartPos + i);
        }
    }

    private boolean evaluatePredicate(int tIx1, int tIx2) {
        if (this.isReversed) {
            return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorInner, tIx2, (IFrameTupleAccessor)this.accessorOuter, tIx1);
        }
        return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorOuter, tIx1, (IFrameTupleAccessor)this.accessorInner, tIx2);
    }

    private void appendToResults(int outerTupleId, int innerTupleId, IFrameWriter writer) throws HyracksDataException {
        if (this.isReversed) {
            this.appendResultToFrame(this.accessorInner, innerTupleId, this.accessorOuter, outerTupleId, writer);
        } else {
            this.appendResultToFrame(this.accessorOuter, outerTupleId, this.accessorInner, innerTupleId, writer);
        }
    }

    private void appendResultToFrame(FrameTupleAccessor accessor1, int tupleId1, FrameTupleAccessor accessor2, int tupleId2, IFrameWriter writer) throws HyracksDataException {
        FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)accessor1, (int)tupleId1, (IFrameTupleAccessor)accessor2, (int)tupleId2);
    }

    private void appendMissing(int outerFrameMngrStartPos, int outerFrameTupleCount, IFrameWriter writer) throws HyracksDataException {
        int limit = outerFrameMngrStartPos + outerFrameTupleCount;
        int outerTuplePos = this.outerMatchLOJ.nextClearBit(outerFrameMngrStartPos);
        while (outerTuplePos < limit) {
            int[] ntFieldEndOffsets = this.missingTupleBuilder.getFieldEndOffsets();
            byte[] ntByteArray = this.missingTupleBuilder.getByteArray();
            int ntSize = this.missingTupleBuilder.getSize();
            int outerAccessorTupleIndex = outerTuplePos - outerFrameMngrStartPos;
            FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessorOuter, (int)outerAccessorTupleIndex, (int[])ntFieldEndOffsets, (byte[])ntByteArray, (int)0, (int)ntSize);
            outerTuplePos = this.outerMatchLOJ.nextClearBit(outerTuplePos + 1);
        }
    }

    public void closeCache() throws HyracksDataException {
        if (this.runFileWriter != null) {
            this.runFileWriter.close();
        }
    }

    public void completeJoin(IFrameWriter writer) throws HyracksDataException {
        try {
            this.multiBlockJoin(writer);
        }
        finally {
            this.runFileWriter.eraseClosed();
        }
        this.appender.write(writer, true);
    }

    public void releaseMemory() throws HyracksDataException {
        this.outerBufferMngr.reset();
    }
}

