/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.file.IRecordWriter;
import org.apache.hyracks.dataflow.std.util.StringSerializationUtils;

public abstract class RecordWriter
implements IRecordWriter {
    protected final BufferedWriter bufferedWriter;
    protected final int[] columns;
    protected final char separator;
    public static final char COMMA = ',';

    public RecordWriter(Object[] args) throws Exception {
        OutputStream outputStream = this.createOutputStream(args);
        this.bufferedWriter = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : null;
        this.columns = null;
        this.separator = (char)44;
    }

    public RecordWriter(int[] columns, char separator, Object[] args) throws HyracksDataException {
        OutputStream outputStream = this.createOutputStream(args);
        this.bufferedWriter = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : null;
        this.columns = columns;
        this.separator = separator;
    }

    @Override
    public void close() {
        try {
            this.bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(Object[] record) throws HyracksDataException {
        try {
            if (this.columns == null) {
                for (int i = 0; i < record.length; ++i) {
                    if (i != 0) {
                        this.bufferedWriter.write(this.separator);
                    }
                    this.bufferedWriter.write(StringSerializationUtils.toString(record[i]));
                }
            } else {
                for (int i = 0; i < this.columns.length; ++i) {
                    if (i != 0) {
                        this.bufferedWriter.write(this.separator);
                    }
                    this.bufferedWriter.write(StringSerializationUtils.toString(record[this.columns[i]]));
                }
            }
            this.bufferedWriter.write("\n");
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public abstract OutputStream createOutputStream(Object[] var1) throws HyracksDataException;
}

