/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.dataflow.std.collectors.IPartitionBatchManager;
import org.apache.hyracks.dataflow.std.collectors.InputChannelFrameReader;

public class DeterministicPartitionBatchManager
implements IPartitionBatchManager {
    private final IFrameReader[] partitions;
    private List<IFrameReader> partitionsList;

    public DeterministicPartitionBatchManager(int nSenders) {
        this.partitions = new IFrameReader[nSenders];
    }

    @Override
    public synchronized void addPartition(PartitionId partitionId, IInputChannel channel) {
        InputChannelFrameReader channelReader = new InputChannelFrameReader(channel);
        channel.registerMonitor((IInputChannelMonitor)channelReader);
        this.partitions[partitionId.getSenderIndex()] = channelReader;
        if (this.allPartitionsAdded()) {
            this.partitionsList = new ArrayList<IFrameReader>(Arrays.asList(this.partitions));
            this.notifyAll();
        }
    }

    @Override
    public synchronized void getNextBatch(List<IFrameReader> batch, int requestedSize) throws HyracksDataException {
        while (!this.allPartitionsAdded()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (this.partitionsList.isEmpty()) {
            return;
        }
        if (requestedSize >= this.partitionsList.size()) {
            batch.addAll(this.partitionsList);
            this.partitionsList.clear();
        } else {
            List<IFrameReader> subBatch = this.partitionsList.subList(0, requestedSize);
            batch.addAll(subBatch);
            subBatch.clear();
        }
    }

    private boolean allPartitionsAdded() {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != null) continue;
            return false;
        }
        return true;
    }
}

