/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.bloomfilter.impls;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.MurmurHash128Bit;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.PageWriteFailureCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class BloomFilter {
    private static final int METADATA_PAGE_ID = 0;
    private static final int NUM_PAGES_OFFSET = 0;
    private static final int NUM_HASHES_USED_OFFSET = 4;
    private static final int NUM_ELEMENTS_OFFSET = 8;
    private static final int NUM_BITS_OFFSET = 16;
    private static final int VERSION_OFFSET = 24;
    private static final int NUM_BITS_PER_BLOCK = 512;
    private static final int DEFAULT_BLOOM_FILTER_VERSION = 0;
    private static final int BLOCKED_BLOOM_FILTER_VERSION = 1;
    private final IBufferCache bufferCache;
    private final FileReference file;
    private final int[] keyFields;
    private int fileId = -1;
    private boolean isActivated = false;
    private int numPages;
    private int numHashes;
    private long numElements;
    private long numBits;
    private int version;
    private final int numBitsPerPage;
    private final int numBlocksPerPage;
    private ICachedPage[] pages;
    private int pinCount = 0;
    private boolean pagesPinned = false;
    private static final byte[] ZERO_BUFFER = new byte[131072];
    private static final long SEED = 0L;

    public BloomFilter(IBufferCache bufferCache, FileReference file, int[] keyFields) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.file = file;
        this.keyFields = keyFields;
        this.numBitsPerPage = bufferCache.getPageSize() * 8;
        this.numBlocksPerPage = this.numBitsPerPage / 512;
    }

    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public synchronized void pinAllPages() throws HyracksDataException {
        if (this.pinCount == 0) {
            if (this.pages == null) {
                this.pages = new ICachedPage[this.numPages];
            }
            for (int i = 0; i < this.numPages; ++i) {
                this.pages[i] = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)(i + 1)), false);
            }
            this.pagesPinned = true;
        }
        ++this.pinCount;
    }

    public synchronized void unpinAllPages() throws HyracksDataException {
        if (this.pinCount == 1) {
            for (int i = 0; i < this.numPages; ++i) {
                this.bufferCache.unpin(this.pages[i]);
            }
            this.pagesPinned = false;
        }
        --this.pinCount;
    }

    public int getNumPages() throws HyracksDataException {
        if (!this.isActivated) {
            this.activate();
        }
        return this.numPages;
    }

    public long getNumElements() throws HyracksDataException {
        if (!this.isActivated) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_GET_NUMBER_OF_ELEMENT_FROM_INACTIVE_FILTER, (Serializable[])new Serializable[0]);
        }
        return this.numElements;
    }

    public boolean contains(ITupleReference tuple, long[] hashes) throws HyracksDataException {
        this.computeHashes(tuple, hashes);
        return this.contains(hashes);
    }

    public boolean contains(long[] hashes) throws HyracksDataException {
        if (this.numPages == 0) {
            return false;
        }
        if (this.version == 1) {
            return this.blockContains(hashes);
        }
        return this.legacyContains(hashes);
    }

    public void computeHashes(ITupleReference tuple, long[] hashes) {
        MurmurHash128Bit.hash3_x64_128(tuple, this.keyFields, 0L, hashes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockContains(long[] hashes) throws HyracksDataException {
        long hash = Math.abs(hashes[0] % this.numBits);
        long blockId = hash / 512L;
        int pageId = (int)(blockId / (long)this.numBlocksPerPage);
        long groupStartIndex = blockId % (long)this.numBlocksPerPage * 512L;
        boolean unpinWhenExit = false;
        ICachedPage page = null;
        if (this.pagesPinned) {
            page = this.pages[pageId];
        } else {
            page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)(pageId + 1)), false);
            unpinWhenExit = true;
        }
        ByteBuffer buffer = page.getBuffer();
        try {
            for (int i = 1; i < this.numHashes; ++i) {
                int bitIndex;
                hash = Math.abs((hashes[0] + (long)i * hashes[1]) % 512L);
                int byteIndex = (int)(hash + groupStartIndex >> 3);
                byte b = buffer.get(byteIndex);
                if (((long)b & 1L << (bitIndex = (int)(hash & 7L))) != 0L) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (unpinWhenExit) {
                this.bufferCache.unpin(page);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean legacyContains(long[] hashes) throws HyracksDataException {
        for (int i = 0; i < this.numHashes; ++i) {
            long hash = Math.abs((hashes[0] + (long)i * hashes[1]) % this.numBits);
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)((int)(hash / (long)this.numBitsPerPage) + 1)), false);
            page.acquireReadLatch();
            try {
                ByteBuffer buffer = page.getBuffer();
                int byteIndex = (int)(hash % (long)this.numBitsPerPage) >> 3;
                byte b = buffer.get(byteIndex);
                int bitIndex = (int)(hash % (long)this.numBitsPerPage) & 7;
                if (((long)b & 1L << bitIndex) != 0L) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        return true;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_ACTIVE_BLOOM_FILTER, (Serializable[])new Serializable[0]);
        }
        this.fileId = this.bufferCache.createFile(this.file);
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            return;
        }
        if (this.fileId >= 0) {
            this.bufferCache.openFile(this.fileId);
        } else {
            this.fileId = this.bufferCache.openFile(this.file);
        }
        this.readBloomFilterMetaData();
        this.isActivated = true;
    }

    private void readBloomFilterMetaData() throws HyracksDataException {
        if (this.bufferCache.getNumPagesOfFile(this.fileId) == 0) {
            this.numPages = 0;
            this.numHashes = 0;
            this.numElements = 0L;
            this.numBits = 0L;
            this.version = 0;
            return;
        }
        ICachedPage metaPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)0), false);
        metaPage.acquireReadLatch();
        try {
            this.numPages = metaPage.getBuffer().getInt(0);
            this.numHashes = metaPage.getBuffer().getInt(4);
            this.numElements = metaPage.getBuffer().getLong(8);
            this.numBits = metaPage.getBuffer().getLong(16);
            this.version = metaPage.getBuffer().getInt(24);
        }
        finally {
            metaPage.releaseReadLatch();
            this.bufferCache.unpin(metaPage);
        }
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActivated) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DEACTIVATE_INACTIVE_BLOOM_FILTER, (Serializable[])new Serializable[0]);
        }
        if (this.pagesPinned) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DEACTIVATE_PINNED_BLOOM_FILTER, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.closeFile(this.fileId);
        this.isActivated = false;
    }

    public void purge() throws HyracksDataException {
        if (this.isActivated) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_PURGE_ACTIVE_BLOOM_FILTER, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.purgeHandle(this.fileId);
        this.fileId = -1;
    }

    public static long[] createHashArray() {
        return new long[2];
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DESTROY_ACTIVE_BLOOM_FILTER, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.deleteFile(this.file);
    }

    public IIndexBulkLoader createBuilder(long numElements, int numHashes, int numBitsPerElement, IPageWriteCallback callback) throws HyracksDataException {
        return new BloomFilterBuilder(numElements, numHashes, numBitsPerElement, callback);
    }

    public class BloomFilterBuilder
    extends PageWriteFailureCallback
    implements IIndexBulkLoader {
        private final long[] hashes = BloomFilter.createHashArray();
        private final long estimatedNumElements;
        private final int numHashes;
        private final long numBits;
        private final int numPages;
        private long actualNumElements;
        private final IFIFOPageWriter pageWriter;
        private final ICachedPage[] pages;
        private ICachedPage metaDataPage = null;

        public BloomFilterBuilder(long estimatedNumElemenets, int numHashes, int numBitsPerElement, IPageWriteCallback callback) throws HyracksDataException {
            int currentPageId;
            if (!BloomFilter.this.isActivated) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_BLOOM_FILTER_BUILDER_FOR_INACTIVE_FILTER, (Serializable[])new Serializable[0]);
            }
            this.pageWriter = BloomFilter.this.bufferCache.createFIFOWriter(callback, (IPageWriteFailureCallback)this);
            this.estimatedNumElements = estimatedNumElemenets;
            this.numHashes = numHashes;
            this.numBits = this.estimatedNumElements * (long)numBitsPerElement;
            long tmp = (long)Math.ceil((double)this.numBits / (double)BloomFilter.this.numBitsPerPage);
            if (tmp > Integer.MAX_VALUE) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_BLOOM_FILTER_WITH_NUMBER_OF_PAGES, (Serializable[])new Serializable[]{Long.valueOf(tmp)});
            }
            this.numPages = (int)tmp;
            this.actualNumElements = 0L;
            this.pages = new ICachedPage[this.numPages];
            try {
                for (currentPageId = 1; currentPageId <= this.numPages; ++currentPageId) {
                    ICachedPage page = BloomFilter.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)BloomFilter.this.fileId, (int)currentPageId));
                    this.initPage(page.getBuffer().array());
                    this.pages[currentPageId - 1] = page;
                }
            }
            catch (Throwable th) {
                for (int i = 0; i < currentPageId; ++i) {
                    if (this.pages[i] == null) continue;
                    BloomFilter.this.bufferCache.returnPage(this.pages[i]);
                }
                throw th;
            }
        }

        private void initPage(byte[] array) {
            int numRounds = array.length / ZERO_BUFFER.length;
            int leftOver = array.length % ZERO_BUFFER.length;
            int destPos = 0;
            for (int i = 0; i < numRounds; ++i) {
                System.arraycopy(ZERO_BUFFER, 0, array, destPos, ZERO_BUFFER.length);
                destPos = (i + 1) * ZERO_BUFFER.length;
            }
            if (leftOver > 0) {
                System.arraycopy(ZERO_BUFFER, 0, array, destPos, leftOver);
            }
        }

        private void allocateAndInitMetaDataPage() throws HyracksDataException {
            if (this.metaDataPage == null) {
                this.metaDataPage = BloomFilter.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)BloomFilter.this.fileId, (int)0));
            }
            this.metaDataPage.getBuffer().putInt(0, this.numPages);
            this.metaDataPage.getBuffer().putInt(4, this.numHashes);
            this.metaDataPage.getBuffer().putLong(8, this.actualNumElements);
            this.metaDataPage.getBuffer().putLong(16, this.numBits);
            this.metaDataPage.getBuffer().putInt(24, 1);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            if (this.numPages == 0) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ADD_TUPLES_TO_DUMMY_BLOOM_FILTER, (Serializable[])new Serializable[0]);
            }
            ++this.actualNumElements;
            MurmurHash128Bit.hash3_x64_128(tuple, BloomFilter.this.keyFields, 0L, this.hashes);
            long hash = Math.abs(this.hashes[0] % this.numBits);
            long groupId = hash / 512L;
            int pageId = (int)(groupId / (long)BloomFilter.this.numBlocksPerPage);
            long groupStartIndex = groupId % (long)BloomFilter.this.numBlocksPerPage * 512L;
            ICachedPage page = this.pages[pageId];
            ByteBuffer buffer = page.getBuffer();
            for (int i = 1; i < this.numHashes; ++i) {
                hash = Math.abs((this.hashes[0] + (long)i * this.hashes[1]) % 512L);
                int byteIndex = (int)(hash + groupStartIndex >> 3);
                byte b = buffer.get(byteIndex);
                int bitIndex = (int)(hash & 7L);
                b = (byte)(b | 1 << bitIndex);
                buffer.put(byteIndex, b);
            }
        }

        public void end() throws HyracksDataException {
            this.allocateAndInitMetaDataPage();
            this.pageWriter.write(this.metaDataPage);
            for (ICachedPage p : this.pages) {
                this.pageWriter.write(p);
            }
            if (this.hasFailed()) {
                throw HyracksDataException.create((Throwable)this.getFailure());
            }
            BloomFilter.this.numBits = this.numBits;
            BloomFilter.this.numHashes = this.numHashes;
            BloomFilter.this.numElements = this.actualNumElements;
            BloomFilter.this.numPages = this.numPages;
            BloomFilter.this.version = 1;
        }

        public void abort() throws HyracksDataException {
            for (ICachedPage p : this.pages) {
                if (p == null) continue;
                BloomFilter.this.bufferCache.returnPage(p, false);
            }
            if (this.metaDataPage != null) {
                BloomFilter.this.bufferCache.returnPage(this.metaDataPage, false);
            }
        }

        public void force() throws HyracksDataException {
            BloomFilter.this.bufferCache.force(BloomFilter.this.fileId, false);
        }
    }
}

