/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import org.apache.hyracks.storage.common.buffercache.CachedPage;

public class BufferCacheHeaderHelper {
    private static final int FRAME_MULTIPLIER_OFF = 0;
    private static final int EXTRA_BLOCK_PAGE_ID_OFF = 4;
    private final ByteBuffer[] array;
    private final int pageSizeWithHeader;
    private ByteBuffer buf;

    public BufferCacheHeaderHelper(int pageSize) {
        this.pageSizeWithHeader = 8 + pageSize;
        this.buf = ByteBuffer.allocate(this.pageSizeWithHeader);
        this.array = new ByteBuffer[]{this.buf, null};
    }

    public ByteBuffer[] prepareWrite(CachedPage cPage) {
        this.setPageInfo(cPage);
        this.buf.position(0);
        this.buf.limit(8);
        this.array[1] = cPage.buffer;
        return this.array;
    }

    public ByteBuffer prepareWrite(CachedPage cPage, int requiredSize) {
        this.ensureBufferCapacity(requiredSize);
        this.setPageInfo(cPage);
        this.buf.position(8);
        this.buf.limit(this.buf.capacity());
        return this.buf;
    }

    public ByteBuffer prepareRead(int size) {
        this.buf.position(0);
        this.buf.limit(size);
        return this.buf;
    }

    public ByteBuffer processHeader(CachedPage cPage) {
        cPage.setFrameSizeMultiplier(this.buf.getInt(0));
        cPage.setExtraBlockPageId(this.buf.getInt(4));
        this.buf.position(8);
        return this.buf;
    }

    private void setPageInfo(CachedPage cPage) {
        this.buf.putInt(0, cPage.getFrameSizeMultiplier());
        this.buf.putInt(4, cPage.getExtraBlockPageId());
    }

    private void ensureBufferCapacity(int size) {
        int requiredSize = size + 8;
        if (this.buf.capacity() < requiredSize) {
            this.array[0] = this.buf = ByteBuffer.allocate(requiredSize);
        }
        this.buf.limit(this.buf.capacity());
    }
}

