/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EnforcedIndexCursor
implements IIndexCursor {
    private static final boolean STORE_TRACES = false;
    private static final boolean ENFORCE_NEXT_HAS_NEXT = true;
    private static final boolean ENFORCE_OPEN_CLOSE_DESTROY = true;
    private static final Logger LOGGER = LogManager.getLogger();
    private State state = State.CLOSED;
    private StackTraceElement[] openCallStack;
    private StackTraceElement[] destroyCallStack;

    @Override
    public final void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException("Cannot open a cursor in the state " + this.state);
        }
        this.doOpen(initialState, searchPred);
        this.state = State.OPENED;
    }

    protected abstract void doOpen(ICursorInitialState var1, ISearchPredicate var2) throws HyracksDataException;

    @Override
    public final boolean hasNext() throws HyracksDataException {
        if (this.state != State.OPENED) {
            throw new IllegalStateException("Cannot call hasNext() on a cursor in the state " + this.state);
        }
        return this.doHasNext();
    }

    protected abstract boolean doHasNext() throws HyracksDataException;

    @Override
    public final void next() throws HyracksDataException {
        if (this.state != State.OPENED) {
            throw new IllegalStateException("Cannot call next() on a cursor in the state " + this.state);
        }
        this.doNext();
    }

    protected abstract void doNext() throws HyracksDataException;

    public final void destroy() throws HyracksDataException {
        if (this.state == State.DESTROYED) {
            return;
        }
        if (this.state != State.CLOSED) {
            throw new IllegalStateException("Cannot destroy a cursor in the state " + this.state);
        }
        this.state = State.DESTROYED;
        this.doDestroy();
    }

    protected abstract void doDestroy() throws HyracksDataException;

    @Override
    public final void close() throws HyracksDataException {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Cannot close a cursor in the state " + this.state);
        }
        this.state = State.CLOSED;
        this.doClose();
    }

    protected abstract void doClose() throws HyracksDataException;

    @Override
    public final ITupleReference getTuple() {
        if (this.state == State.OPENED) {
            return this.doGetTuple();
        }
        return null;
    }

    protected abstract ITupleReference doGetTuple();

    static enum State {
        CLOSED,
        OPENED,
        DESTROYED;

    }
}

