/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.LogRedactionUtil;

public class FeedLogManager
implements Closeable {
    private static final String PROGRESS_LOG_FILE_NAME = "progress.log";
    private static final String ERROR_LOG_FILE_NAME = "error.log";
    private static final String BAD_RECORDS_FILE_NAME = "failed_record.log";
    private static final String START_PREFIX = "s:";
    private static final String END_PREFIX = "e:";
    private static final String DATE_FORMAT_STRING = "MM/dd/yyyy HH:mm:ss";
    private static final int PREFIX_SIZE = "s:".length() + "MM/dd/yyyy HH:mm:ss".length() + 1;
    private String currentPartition;
    private final TreeSet<String> completed;
    private final Path dir;
    private BufferedWriter progressLogger;
    private BufferedWriter errorLogger;
    private BufferedWriter recordLogger;
    private final StringBuilder stringBuilder = new StringBuilder();
    private int count = 0;
    private static final DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public FeedLogManager(File file) throws HyracksDataException {
        try {
            this.dir = file.toPath();
            this.completed = new TreeSet();
            if (!this.exists()) {
                this.create();
            }
            this.open();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized void touch() {
        ++this.count;
    }

    public synchronized void endPartition() throws IOException {
        this.logProgress(END_PREFIX + this.currentPartition);
        this.completed.add(this.currentPartition);
    }

    public synchronized void endPartition(String partition) throws IOException {
        this.currentPartition = partition;
        this.logProgress(END_PREFIX + this.currentPartition);
        this.completed.add(this.currentPartition);
    }

    public synchronized void startPartition(String partition) throws IOException {
        this.currentPartition = partition;
        this.logProgress(START_PREFIX + this.currentPartition);
    }

    public boolean exists() {
        return Files.exists(this.dir, new LinkOption[0]);
    }

    public synchronized void open() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.dir.toAbsolutePath().toString() + File.separator + PROGRESS_LOG_FILE_NAME, new String[0]));){
            String log = reader.readLine();
            while (log != null) {
                if (log.startsWith(END_PREFIX)) {
                    this.completed.add(FeedLogManager.getSplitId(log));
                }
                log = reader.readLine();
            }
        }
        this.progressLogger = Files.newBufferedWriter(Paths.get(this.dir.toAbsolutePath().toString() + File.separator + PROGRESS_LOG_FILE_NAME, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.errorLogger = Files.newBufferedWriter(Paths.get(this.dir.toAbsolutePath().toString() + File.separator + ERROR_LOG_FILE_NAME, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.recordLogger = Files.newBufferedWriter(Paths.get(this.dir.toAbsolutePath().toString() + File.separator + BAD_RECORDS_FILE_NAME, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
    }

    @Override
    public synchronized void close() throws IOException {
        --this.count;
        if (this.count > 0) {
            return;
        }
        this.progressLogger.close();
        this.errorLogger.close();
        this.recordLogger.close();
    }

    public synchronized boolean create() throws IOException {
        File f = this.dir.toFile();
        f.mkdirs();
        new File(f, PROGRESS_LOG_FILE_NAME).createNewFile();
        new File(f, ERROR_LOG_FILE_NAME).createNewFile();
        new File(f, BAD_RECORDS_FILE_NAME).createNewFile();
        return true;
    }

    public synchronized boolean destroy() throws IOException {
        File f = this.dir.toFile();
        FileUtils.deleteDirectory((File)f);
        return true;
    }

    private synchronized void logProgress(String log) throws IOException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(df.format(new Date()));
        this.stringBuilder.append(' ');
        this.stringBuilder.append(log);
        this.stringBuilder.append('\n');
        this.progressLogger.write(this.stringBuilder.toString());
        this.progressLogger.flush();
    }

    public synchronized void logError(String error, Throwable th) throws IOException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(df.format(new Date()));
        this.stringBuilder.append(' ');
        this.stringBuilder.append(error);
        this.stringBuilder.append('\n');
        this.stringBuilder.append(th.toString());
        this.stringBuilder.append('\n');
        this.errorLogger.write(this.stringBuilder.toString());
        this.errorLogger.flush();
    }

    public synchronized void logRecord(String record, String errorMessage) throws IOException {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(LogRedactionUtil.userData((String)record));
        this.stringBuilder.append('\n');
        this.stringBuilder.append(df.format(new Date()));
        this.stringBuilder.append(' ');
        this.stringBuilder.append(errorMessage);
        this.stringBuilder.append('\n');
        this.recordLogger.write(this.stringBuilder.toString());
        this.recordLogger.flush();
    }

    private static String getSplitId(String log) {
        return log.substring(PREFIX_SIZE);
    }

    public synchronized boolean isSplitRead(String split) {
        return this.completed.contains(split);
    }

    public static enum LogEntryType {
        START,
        END,
        COMMIT,
        SNAPSHOT;

    }
}

