/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;

public class RecordIdReader {
    private static final byte MISSING_BYTE = ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
    protected FrameTupleAccessor tupleAccessor;
    protected int fieldSlotsLength;
    protected int[] ridFields;
    protected RecordId rid;
    protected RecordDescriptor inRecDesc;
    protected ByteBufferInputStream bbis;
    protected DataInputStream dis;
    protected int tupleStartOffset;
    protected ByteBuffer frameBuffer;

    public RecordIdReader(int[] ridFields) {
        this.ridFields = ridFields;
        this.rid = new RecordId();
    }

    public void set(FrameTupleAccessor accessor, RecordDescriptor inRecDesc) {
        this.tupleAccessor = accessor;
        this.fieldSlotsLength = accessor.getFieldSlotsLength();
        this.inRecDesc = inRecDesc;
        this.bbis = new ByteBufferInputStream();
        this.dis = new DataInputStream((InputStream)this.bbis);
    }

    public RecordId read(int index) throws HyracksDataException {
        this.tupleStartOffset = this.tupleAccessor.getTupleStartOffset(index) + this.fieldSlotsLength;
        int fileNumberStartOffset = this.tupleAccessor.getFieldStartOffset(index, this.ridFields[0]);
        this.frameBuffer = this.tupleAccessor.getBuffer();
        if (this.frameBuffer.get(this.tupleStartOffset + fileNumberStartOffset) == MISSING_BYTE) {
            return null;
        }
        this.bbis.setByteBuffer(this.frameBuffer, this.tupleStartOffset + fileNumberStartOffset);
        this.rid.setFileId(((AInt32)this.inRecDesc.getFields()[this.ridFields[0]].deserialize((DataInput)this.dis)).getIntegerValue());
        this.bbis.setByteBuffer(this.frameBuffer, this.tupleStartOffset + this.tupleAccessor.getFieldStartOffset(index, this.ridFields[1]));
        this.rid.setOffset(((AInt64)this.inRecDesc.getFields()[this.ridFields[1]].deserialize((DataInput)this.dis)).getLongValue());
        return this.rid;
    }
}

