/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.policy;

import java.io.Serializable;
import java.util.Map;

public class FeedPolicyAccessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FLOWCONTROL_ENABLED = "flowcontrol.enabled";
    public static final String SPILL_TO_DISK_ON_CONGESTION = "spill.to.disk.on.congestion";
    public static final String MAX_SPILL_SIZE_ON_DISK = "max.spill.size.on.disk";
    public static final String DISCARD_ON_CONGESTION = "discard.on.congestion";
    public static final String MAX_FRACTION_DISCARD = "max.fraction.discard";
    public static final String ELASTIC = "elastic";
    public static final String LOGGING_STATISTICS = "logging.statistics";
    public static final long NO_LIMIT = -1L;
    private Map<String, String> feedPolicy;

    public Map<String, String> getFeedPolicy() {
        return this.feedPolicy;
    }

    public FeedPolicyAccessor(Map<String, String> feedPolicy) {
        this.feedPolicy = feedPolicy;
    }

    public void reset(Map<String, String> feedPolicy) {
        this.feedPolicy = feedPolicy;
    }

    public boolean flowControlEnabled() {
        return this.getBooleanPropertyValue(FLOWCONTROL_ENABLED, false);
    }

    public boolean spillToDiskOnCongestion() {
        return this.getBooleanPropertyValue(SPILL_TO_DISK_ON_CONGESTION, false);
    }

    public boolean discardOnCongestion() {
        return this.getMaxFractionDiscard() > 0.0f;
    }

    public long getMaxSpillOnDisk() {
        return this.getLongPropertyValue(MAX_SPILL_SIZE_ON_DISK, -1L);
    }

    public float getMaxFractionDiscard() {
        return this.getFloatPropertyValue(MAX_FRACTION_DISCARD, 0.0f);
    }

    private boolean getBooleanPropertyValue(String key, boolean defValue) {
        String v = this.feedPolicy.get(key);
        return v == null ? defValue : Boolean.valueOf(v);
    }

    private long getLongPropertyValue(String key, long defValue) {
        String v = this.feedPolicy.get(key);
        return v != null ? Long.parseLong(v) : defValue;
    }

    private float getFloatPropertyValue(String key, float defValue) {
        String v = this.feedPolicy.get(key);
        return v != null ? Float.parseFloat(v) : defValue;
    }
}

