/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.exceptions;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class InvalidExpressionException
extends CompilationException {
    private static final long serialVersionUID = -3601791480135148643L;

    public InvalidExpressionException(FunctionIdentifier fid, int index, ILogicalExpression actualExpr, LogicalExpressionTag ... exprKinds) {
        super(ErrorCode.COMPILATION_INVALID_EXPRESSION, new Serializable[]{fid.getName(), ExceptionUtil.indexToPosition(index), actualExpr.toString(), ExceptionUtil.toExpectedTypeString(exprKinds)});
    }

    public InvalidExpressionException(SourceLocation sourceLoc, FunctionIdentifier fid, int index, ILogicalExpression actualExpr, LogicalExpressionTag ... exprKinds) {
        super(ErrorCode.COMPILATION_INVALID_EXPRESSION, sourceLoc, new Serializable[]{fid.getName(), ExceptionUtil.indexToPosition(index), actualExpr.toString(), ExceptionUtil.toExpectedTypeString(exprKinds)});
    }

    @Deprecated
    public InvalidExpressionException(String functionName, int index, ILogicalExpression actualExpr, LogicalExpressionTag ... exprKinds) {
        super(ErrorCode.COMPILATION_INVALID_EXPRESSION, new Serializable[]{functionName, ExceptionUtil.indexToPosition(index), actualExpr.toString(), ExceptionUtil.toExpectedTypeString(exprKinds)});
    }

    @Deprecated
    public InvalidExpressionException(SourceLocation sourceLoc, String functionName, int index, ILogicalExpression actualExpr, LogicalExpressionTag ... exprKinds) {
        super(ErrorCode.COMPILATION_INVALID_EXPRESSION, sourceLoc, new Serializable[]{functionName, ExceptionUtil.indexToPosition(index), actualExpr.toString(), ExceptionUtil.toExpectedTypeString(exprKinds)});
    }
}

