/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class ACircle
implements IAObject {
    protected APoint center;
    protected double radius;

    public ACircle(APoint center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public APoint getP() {
        return this.center;
    }

    public void setP(APoint p) {
        this.center = p;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ACIRCLE;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof ACircle)) {
            return false;
        }
        ACircle c = (ACircle)obj;
        return this.radius == c.radius && this.center.deepEqual(c.center);
    }

    @Override
    public int hash() {
        return (int)((double)this.center.hash() + this.radius);
    }

    public String toString() {
        return "circle: { \"center\": " + this.center + ", \"radius\":" + this.radius + "}";
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode circle = om.createObjectNode();
        circle.set("center", (JsonNode)this.center.toJSON());
        circle.put("radius", this.radius);
        json.set("ACircle", (JsonNode)circle);
        return json;
    }
}

