/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class SubstituteVariableVisitor
implements ILogicalOperatorVisitor<Void, Pair<LogicalVariable, LogicalVariable>> {
    private final ITypingContext ctx;
    private final boolean goThroughNts;

    public SubstituteVariableVisitor(boolean goThroughNts, ITypingContext ctx) {
        this.goThroughNts = goThroughNts;
        this.ctx = ctx;
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substAssignVariables(op.getVariables(), op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substAssignVariables(op.getVariables(), op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            if (op.getExplicitOrderingProperty() != null) {
                List<OrderColumn> orderColumns = op.getExplicitOrderingProperty().getOrderColumns();
                ArrayList<OrderColumn> newOrderColumns = new ArrayList<OrderColumn>(orderColumns.size());
                for (OrderColumn oc : orderColumns) {
                    LogicalVariable columnVar = oc.getColumn();
                    LogicalVariable newColumnVar = columnVar.equals(pair.first) ? (LogicalVariable)pair.second : columnVar;
                    newOrderColumns.add(new OrderColumn(newColumnVar, oc.getOrder()));
                }
                op.setExplicitOrderingProperty(new LocalOrderProperty(newOrderColumns));
            }
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substProducedVariables(op.getVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (!producedVarFound && op.isProjectPushed()) {
            producedVarFound = this.substProducedVariables(op.getProjectVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariablesInExpr(op.getSelectCondition(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariables(op.getMinFilterVars(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariables(op.getMaxFilterVars(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Pair<LogicalVariable, LogicalVariable> pair) {
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Pair<LogicalVariable, LogicalVariable> pair) {
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substGbyVariables(op.getGroupByList(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (!producedVarFound) {
            producedVarFound = this.substGbyVariables(op.getDecorList(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        if (!producedVarFound) {
            this.substInNestedPlans(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substProducedVarInTypeEnvironment(op, pair);
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getCondition(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getCondition(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substProducedVarInTypeEnvironment(op, pair);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getMaxObjects(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getOffset(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> oe : op.getOrderExpressions()) {
            this.substUsedVariablesInExpr((Mutable<ILogicalExpression>)((Mutable)oe.second), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariables(op.getVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substAssignVariables(op.getVariables(), op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substProducedVariables(op.getOutputVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariables(op.getInputVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getCondition(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substProducedVarInTypeEnvironment(op, pair);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substInNestedPlans(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substUnionAllVariables(op.getVariableMappings(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substProducedVariables(op.getOutputCompareVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (!producedVarFound && op.hasExtraVariables()) {
            producedVarFound = this.substProducedVariables(op.getOutputExtraVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            int n = op.getNumInput();
            for (int i = 0; i < n; ++i) {
                this.substUsedVariables(op.getInputCompareVariables(i), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
                if (!op.hasExtraVariables()) continue;
                this.substUsedVariables(op.getInputExtraVariables(i), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            }
        }
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substituteVarsForAbstractUnnestMapOp(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariablesInExpr(op.getSelectCondition(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substituteVarsForAbstractUnnestMapOp(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    private boolean substituteVarsForAbstractUnnestMapOp(AbstractUnnestMapOperator op, LogicalVariable v1, LogicalVariable v2) {
        boolean producedVarFound = this.substProducedVariables(op.getVariables(), v1, v2);
        if (!producedVarFound) {
            this.substUsedVariablesInExpr(op.getExpressionRef(), v1, v2);
            this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), v1, v2);
            this.substUsedVariables(op.getMinFilterVars(), v1, v2);
            this.substUsedVariables(op.getMaxFilterVars(), v1, v2);
        }
        return producedVarFound;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substituteVarsForAbstractUnnestNonMapOp(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substituteVarsForAbstractUnnestNonMapOp(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        }
        return null;
    }

    private boolean substituteVarsForAbstractUnnestNonMapOp(AbstractUnnestNonMapOperator op, LogicalVariable v1, LogicalVariable v2) {
        boolean producedVarFound = this.substProducedVariables(op.getVariables(), v1, v2);
        if (!producedVarFound && op.hasPositionalVariable() && op.getPositionalVariable().equals(v1)) {
            op.setPositionalVariable(v2);
            producedVarFound = true;
        }
        if (!producedVarFound) {
            this.substUsedVariablesInExpr(op.getExpressionRef(), v1, v2);
        }
        return producedVarFound;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getPayloadExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getBranchingExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = false;
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            if (op.getUpsertIndicatorVar() != null && op.getUpsertIndicatorVar().equals(pair.first)) {
                op.setUpsertIndicatorVar((LogicalVariable)pair.second);
                producedVarFound = true;
            } else if (op.getBeforeOpRecordVar() != null && op.getBeforeOpRecordVar().equals(pair.first)) {
                op.setPrevRecordVar((LogicalVariable)pair.second);
                producedVarFound = true;
            } else if (op.getBeforeOpFilterVar() != null && op.getBeforeOpFilterVar().equals(pair.first)) {
                op.setPrevFilterVar((LogicalVariable)pair.second);
                producedVarFound = true;
            } else {
                producedVarFound = this.substProducedVariables(op.getBeforeOpAdditionalNonFilteringVars(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            }
        }
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariablesInExpr(op.getPayloadExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getPrimaryKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getAdditionalNonFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getPrimaryKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getSecondaryKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getFilterExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getUpsertIndicatorExpr(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getPrevSecondaryKeyExprs(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substUsedVariablesInExpr(op.getPrevAdditionalFilteringExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (!op.getNestedPlans().isEmpty()) {
            this.substInNestedPlans(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substProducedVariables(op.getTokenizeVars(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariablesInExpr(op.getPrimaryKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getSecondaryKeyExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFilterExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getAdditionalFilteringExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substUsedVariablesInExpr(op.getSideDataExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean producedVarFound = this.substAssignVariables(op.getVariables(), op.getExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (producedVarFound) {
            this.substProducedVarInTypeEnvironment(op, pair);
        } else {
            this.substUsedVariablesInExpr(op.getPartitionExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getOrderExpressions()) {
                this.substUsedVariablesInExpr((Mutable<ILogicalExpression>)((Mutable)p.second), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            }
            for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getFrameValueExpressions()) {
                this.substUsedVariablesInExpr((Mutable<ILogicalExpression>)((Mutable)p.second), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            }
            this.substUsedVariablesInExpr(op.getFrameStartExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameStartValidationExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameEndExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameEndValidationExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameExcludeExpressions(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameExcludeUnaryExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substUsedVariablesInExpr(op.getFrameOffsetExpression(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            this.substInNestedPlans(op, (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    private void substUsedVariablesInExpr(Mutable<ILogicalExpression> exprRef, LogicalVariable v1, LogicalVariable v2) {
        if (exprRef != null && exprRef.getValue() != null) {
            ((ILogicalExpression)exprRef.getValue()).substituteVar(v1, v2);
        }
    }

    private void substUsedVariablesInExpr(List<Mutable<ILogicalExpression>> expressions, LogicalVariable v1, LogicalVariable v2) {
        if (expressions != null) {
            for (Mutable<ILogicalExpression> exprRef : expressions) {
                this.substUsedVariablesInExpr(exprRef, v1, v2);
            }
        }
    }

    private void substUsedVariables(List<LogicalVariable> variables, LogicalVariable v1, LogicalVariable v2) {
        if (variables != null) {
            int n = variables.size();
            for (int i = 0; i < n; ++i) {
                if (!variables.get(i).equals(v1)) continue;
                variables.set(i, v2);
            }
        }
    }

    private boolean substProducedVariables(List<LogicalVariable> variables, LogicalVariable v1, LogicalVariable v2) {
        if (variables != null) {
            int n = variables.size();
            for (int i = 0; i < n; ++i) {
                if (!variables.get(i).equals(v1)) continue;
                variables.set(i, v2);
                return true;
            }
        }
        return false;
    }

    private boolean substAssignVariables(List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions, LogicalVariable v1, LogicalVariable v2) {
        int n = variables.size();
        for (int i = 0; i < n; ++i) {
            if (variables.get(i).equals(v1)) {
                variables.set(i, v2);
                return true;
            }
            ((ILogicalExpression)expressions.get(i).getValue()).substituteVar(v1, v2);
        }
        return false;
    }

    private boolean substGbyVariables(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> gbyPairList, LogicalVariable v1, LogicalVariable v2) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : gbyPairList) {
            if (ve.first != null && ((LogicalVariable)ve.first).equals(v1)) {
                ve.first = v2;
                return true;
            }
            ((ILogicalExpression)((Mutable)ve.second).getValue()).substituteVar(v1, v2);
        }
        return false;
    }

    private boolean substUnionAllVariables(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap, LogicalVariable v1, LogicalVariable v2) {
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : varMap) {
            if (((LogicalVariable)t.first).equals(v1)) {
                t.first = v2;
            }
            if (((LogicalVariable)t.second).equals(v1)) {
                t.second = v2;
            }
            if (!((LogicalVariable)t.third).equals(v1)) continue;
            t.third = v2;
            return true;
        }
        return false;
    }

    private void substInNestedPlans(AbstractOperatorWithNestedPlans op, LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)r.getValue(), v1, v2, this.ctx);
            }
        }
    }

    private void substProducedVarInTypeEnvironment(ILogicalOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        if (this.ctx == null) {
            return;
        }
        IVariableTypeEnvironment env = this.ctx.getOutputTypeEnvironment(op);
        if (env != null) {
            env.substituteProducedVariable((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
    }
}

