/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class GroupByOperator
extends AbstractOperatorWithNestedPlans {
    private final List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> gByList;
    private final List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorList;
    private boolean groupAll = false;
    private boolean global = true;

    public GroupByOperator() {
        this.gByList = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        this.decorList = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
    }

    public GroupByOperator(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> groupByList, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorList, List<ILogicalPlan> nestedPlans) {
        this(groupByList, decorList, nestedPlans, false);
    }

    public GroupByOperator(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> groupByList, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorList, List<ILogicalPlan> nestedPlans, boolean groupAll) {
        super(nestedPlans);
        this.decorList = decorList;
        this.gByList = groupByList;
        this.groupAll = groupAll;
        this.checkGroupAll(groupAll);
    }

    public void addGbyExpression(LogicalVariable variable, ILogicalExpression expression) {
        this.gByList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)variable, (Object)new MutableObject((Object)expression)));
    }

    public void addDecorExpression(LogicalVariable variable, ILogicalExpression expression) {
        this.decorList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)variable, (Object)new MutableObject((Object)expression)));
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.GROUP;
    }

    public List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> getGroupByList() {
        return this.gByList;
    }

    public List<LogicalVariable> getGroupByVarList() {
        ArrayList<LogicalVariable> varList = new ArrayList<LogicalVariable>(this.gByList.size());
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : this.gByList) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)ve.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression v = (VariableReferenceExpression)expr;
            varList.add(v.getVariableReference());
        }
        return varList;
    }

    public static String veListToString(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> vePairList) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean fst = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : vePairList) {
            if (fst) {
                fst = false;
            } else {
                sb.append("; ");
            }
            if (ve.first != null) {
                sb.append(ve.first + " := " + ve.second);
                continue;
            }
            sb.append(((Mutable)ve.second).getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void recomputeSchema() {
        super.recomputeSchema();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.gByList) {
            this.schema.add((LogicalVariable)p.first);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.decorList) {
            this.schema.add(GroupByOperator.getDecorVariable(p));
        }
    }

    @Override
    public void getProducedVariablesExceptNestedPlans(Collection<LogicalVariable> vars) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.gByList) {
            if (p.first == null) continue;
            vars.add((LogicalVariable)p.first);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.decorList) {
            if (p.first == null) continue;
            vars.add((LogicalVariable)p.first);
        }
    }

    @Override
    public void getUsedVariablesExceptNestedPlans(Collection<LogicalVariable> vars) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> g : this.gByList) {
            ((ILogicalExpression)((Mutable)g.second).getValue()).getUsedVariables(vars);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> g : this.decorList) {
            ((ILogicalExpression)((Mutable)g.second).getValue()).getUsedVariables(vars);
        }
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                VariableReferenceExpression v;
                ILogicalExpression expr;
                for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : GroupByOperator.this.gByList) {
                    expr = (ILogicalExpression)((Mutable)p.second).getValue();
                    if (p.first != null) {
                        target.addVariable((LogicalVariable)p.first);
                        continue;
                    }
                    if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        throw new AlgebricksException("group-by expects variable references.");
                    }
                    v = (VariableReferenceExpression)expr;
                    target.addVariable(v.getVariableReference());
                }
                for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : GroupByOperator.this.decorList) {
                    expr = (ILogicalExpression)((Mutable)p.second).getValue();
                    if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        throw new AlgebricksException("group-by expects variable references.");
                    }
                    v = (VariableReferenceExpression)expr;
                    LogicalVariable decor = v.getVariableReference();
                    if (p.first != null) {
                        target.addVariable((LogicalVariable)p.first);
                        continue;
                    }
                    target.addVariable(decor);
                }
            }
        };
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean b = false;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.gByList) {
            if (!visitor.transform((Mutable<ILogicalExpression>)((Mutable)p.second))) continue;
            b = true;
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.decorList) {
            if (!visitor.transform((Mutable<ILogicalExpression>)((Mutable)p.second))) continue;
            b = true;
        }
        return b;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitGroupByOperator(this, arg);
    }

    public static LogicalVariable getDecorVariable(Pair<LogicalVariable, Mutable<ILogicalExpression>> p) {
        if (p.first != null) {
            return (LogicalVariable)p.first;
        }
        VariableReferenceExpression e = (VariableReferenceExpression)((Mutable)p.second).getValue();
        return e.getVariableReference();
    }

    public List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> getDecorList() {
        return this.decorList;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        LogicalVariable v2;
        VariableReferenceExpression vre;
        ILogicalExpression expr;
        PropagatingTypeEnvironment env = this.createNestedPlansPropagatingTypeEnvironment(ctx, false);
        ILogicalOperator child = (ILogicalOperator)((Mutable)this.inputs.get(0)).getValue();
        IVariableTypeEnvironment env2 = ctx.getOutputTypeEnvironment(child);
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.getGroupByList()) {
            expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (p.first != null) {
                env.setVarType((LogicalVariable)p.first, env2.getType(expr));
                if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                LogicalVariable v1 = ((VariableReferenceExpression)expr).getVariableReference();
                env.setVarType(v1, env2.getVarType(v1));
                continue;
            }
            vre = (VariableReferenceExpression)((Mutable)p.second).getValue();
            v2 = vre.getVariableReference();
            env.setVarType(v2, env2.getVarType(v2));
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : this.getDecorList()) {
            expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (p.first != null) {
                env.setVarType((LogicalVariable)p.first, env2.getType(expr));
                continue;
            }
            vre = (VariableReferenceExpression)((Mutable)p.second).getValue();
            v2 = vre.getVariableReference();
            env.setVarType(v2, env2.getVarType(v2));
        }
        return env;
    }

    public boolean isGroupAll() {
        return this.groupAll;
    }

    public void setGroupAll(boolean groupAll) {
        this.groupAll = groupAll;
        this.checkGroupAll(groupAll);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    private void checkGroupAll(boolean groupAll) {
        if (groupAll && !this.gByList.isEmpty()) {
            throw new IllegalStateException("Conflicting parameters for GROUP BY: there should be no GROUP BY keys when the GROUP ALL flag is set to true");
        }
    }
}

