/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.io.Serializable;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SetMemoryRequirementsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        IPhysicalOperator physOp = op.getPhysicalOperator();
        if (physOp.getLocalMemoryRequirements() != null) {
            return false;
        }
        this.computeLocalMemoryRequirements(op, this.createMemoryRequirementsConfigurator(context));
        return true;
    }

    private void computeLocalMemoryRequirements(AbstractLogicalOperator op, ILogicalOperatorVisitor<Void, Void> memoryRequirementsVisitor) throws AlgebricksException {
        IPhysicalOperator physOp = op.getPhysicalOperator();
        if (physOp.getLocalMemoryRequirements() == null) {
            physOp.createLocalMemoryRequirements((ILogicalOperator)op);
            if (physOp.getLocalMemoryRequirements() == null) {
                throw new IllegalStateException(physOp.getOperatorTag().toString());
            }
            if (memoryRequirementsVisitor != null) {
                op.accept(memoryRequirementsVisitor, null);
            }
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                for (Mutable root : p.getRoots()) {
                    this.computeLocalMemoryRequirements((AbstractLogicalOperator)root.getValue(), memoryRequirementsVisitor);
                }
            }
        }
        for (Mutable opRef : op.getInputs()) {
            this.computeLocalMemoryRequirements((AbstractLogicalOperator)opRef.getValue(), memoryRequirementsVisitor);
        }
    }

    protected ILogicalOperatorVisitor<Void, Void> createMemoryRequirementsConfigurator(IOptimizationContext context) {
        return new MemoryRequirementsConfigurator(context);
    }

    protected static class MemoryRequirementsConfigurator
    implements ILogicalOperatorVisitor<Void, Void> {
        protected final IOptimizationContext context;
        protected final PhysicalOptimizationConfig physConfig;

        protected MemoryRequirementsConfigurator(IOptimizationContext context) {
            this.context = context;
            this.physConfig = context.getPhysicalOptimizationConfig();
        }

        protected void setOperatorMemoryBudget(AbstractLogicalOperator op, int memBudgetInFrames) throws AlgebricksException {
            LocalMemoryRequirements memoryReqs = op.getPhysicalOperator().getLocalMemoryRequirements();
            int minBudgetInFrames = memoryReqs.getMinMemoryBudgetInFrames();
            if (memBudgetInFrames < minBudgetInFrames) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_MEMORY_BUDGET, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag().toString(), Integer.valueOf(memBudgetInFrames * this.physConfig.getFrameSize()), Integer.valueOf(minBudgetInFrames * this.physConfig.getFrameSize())});
            }
            memoryReqs.setMemoryBudgetInFrames(memBudgetInFrames);
        }

        public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
            this.setOperatorMemoryBudget((AbstractLogicalOperator)op, this.physConfig.getMaxFramesExternalSort());
            return null;
        }

        public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
            this.setOperatorMemoryBudget((AbstractLogicalOperator)op, this.physConfig.getMaxFramesForGroupBy());
            return null;
        }

        public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
            if (op.getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.WINDOW) {
                this.setOperatorMemoryBudget((AbstractLogicalOperator)op, this.physConfig.getMaxFramesForWindow());
            }
            return null;
        }

        public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
            return this.visitJoinOperator((AbstractBinaryJoinOperator)op, arg);
        }

        public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
            return this.visitJoinOperator((AbstractBinaryJoinOperator)op, arg);
        }

        protected Void visitJoinOperator(AbstractBinaryJoinOperator op, Void arg) throws AlgebricksException {
            this.setOperatorMemoryBudget((AbstractLogicalOperator)op, this.physConfig.getMaxFramesForJoin());
            return null;
        }

        public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
            return this.visitAbstractUnnestMapOperator((AbstractUnnestMapOperator)op, arg);
        }

        public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
            return this.visitAbstractUnnestMapOperator((AbstractUnnestMapOperator)op, arg);
        }

        protected Void visitAbstractUnnestMapOperator(AbstractUnnestMapOperator op, Void arg) throws AlgebricksException {
            IPhysicalOperator physOp = op.getPhysicalOperator();
            if (physOp.getOperatorTag() == PhysicalOperatorTag.LENGTH_PARTITIONED_INVERTED_INDEX_SEARCH || physOp.getOperatorTag() == PhysicalOperatorTag.SINGLE_PARTITION_INVERTED_INDEX_SEARCH) {
                this.setOperatorMemoryBudget((AbstractLogicalOperator)op, this.physConfig.getMaxFramesForTextSearch());
            }
            return null;
        }

        public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
            return null;
        }
    }
}

