/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveCartesianProductWithEmptyBranchRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOperator = (AbstractBinaryJoinOperator)op;
        ILogicalOperator left = (ILogicalOperator)((Mutable)joinOperator.getInputs().get(0)).getValue();
        ILogicalOperator right = (ILogicalOperator)((Mutable)joinOperator.getInputs().get(1)).getValue();
        if (!((ILogicalExpression)joinOperator.getCondition().getValue()).equals(ConstantExpression.TRUE)) {
            return false;
        }
        if (this.emptyBranch(left)) {
            opRef.setValue((Object)right);
            return true;
        }
        if (this.emptyBranch(right)) {
            opRef.setValue((Object)left);
            return true;
        }
        return false;
    }

    private boolean emptyBranch(ILogicalOperator op) throws AlgebricksException {
        if (op.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return true;
        }
        HashSet liveVariables = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVariables);
        return liveVariables.isEmpty() && OperatorPropertiesUtil.isCardinalityExactOne((ILogicalOperator)op);
    }
}

