/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class LongParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new LongParserFactory();
    private static final long serialVersionUID = 1L;

    private LongParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){

            @Override
            public boolean parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                char c;
                int i;
                int end = start + length;
                for (i = start; i < end && ((c = buffer[i]) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f'); ++i) {
                }
                boolean negative = false;
                long limit = -9223372036854775807L;
                if (i < end) {
                    c = buffer[i];
                    if (c == '-') {
                        negative = true;
                        limit = Long.MIN_VALUE;
                        ++i;
                    }
                    if (c == '+') {
                        ++i;
                    }
                }
                long result = 0L;
                long multiplicationMin = limit / 10L;
                boolean gotNumber = false;
                while (i < end && (c = buffer[i]) >= '0' && c <= '9') {
                    gotNumber = true;
                    if (result < multiplicationMin) {
                        return false;
                    }
                    int digit = c - 48;
                    if ((result *= 10L) < limit + (long)digit) {
                        return false;
                    }
                    result -= (long)digit;
                    ++i;
                }
                while (i < end) {
                    c = buffer[i];
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                        return false;
                    }
                    ++i;
                }
                if (!gotNumber) {
                    return false;
                }
                try {
                    out.writeLong(negative ? result : -result);
                    return true;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

