/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ReferenceFunction;
import it.unimi.dsi.fastutil.doubles.Double2ReferenceFunction;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.DoubleFunction;

public final class Double2ReferenceFunctions {
    public static final EmptyFunction EMPTY_FUNCTION = new EmptyFunction();

    private Double2ReferenceFunctions() {
    }

    public static <V> Double2ReferenceFunction<V> singleton(double key, V value) {
        return new Singleton<V>(key, value);
    }

    public static <V> Double2ReferenceFunction<V> singleton(Double key, V value) {
        return new Singleton<V>(key, value);
    }

    public static <V> Double2ReferenceFunction<V> synchronize(Double2ReferenceFunction<V> f) {
        return new SynchronizedFunction<V>(f);
    }

    public static <V> Double2ReferenceFunction<V> synchronize(Double2ReferenceFunction<V> f, Object sync) {
        return new SynchronizedFunction<V>(f, sync);
    }

    public static <V> Double2ReferenceFunction<V> unmodifiable(Double2ReferenceFunction<? extends V> f) {
        return new UnmodifiableFunction<V>(f);
    }

    public static <V> Double2ReferenceFunction<V> primitive(java.util.function.Function<? super Double, ? extends V> f) {
        Objects.requireNonNull(f);
        if (f instanceof Double2ReferenceFunction) {
            return (Double2ReferenceFunction)f;
        }
        if (f instanceof DoubleFunction) {
            return ((DoubleFunction)((Object)f))::apply;
        }
        return new PrimitiveFunction<V>(f);
    }

    public static class Singleton<V>
    extends AbstractDouble2ReferenceFunction<V>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final double key;
        protected final V value;

        protected Singleton(double key, V value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(double k) {
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(k);
        }

        public V get(double k) {
            return (V)(Double.doubleToLongBits(this.key) == Double.doubleToLongBits(k) ? this.value : this.defRetValue);
        }

        public V getOrDefault(double k, V defaultValue) {
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(k) ? this.value : defaultValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }

    public static class SynchronizedFunction<V>
    implements Double2ReferenceFunction<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Double2ReferenceFunction<V> function;
        protected final Object sync;

        protected SynchronizedFunction(Double2ReferenceFunction<V> f, Object sync) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = sync;
        }

        protected SynchronizedFunction(Double2ReferenceFunction<V> f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V apply(double operand) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.apply(operand);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public V apply(Double key) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.apply((Object)key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(V defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.function.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public boolean containsKey(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V put(double k, V v) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(double k) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V getOrDefault(double k, V defaultValue) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V remove(double k) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.function.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public V put(Double k, V v) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public V get(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public V getOrDefault(Object k, V defaultValue) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public V remove(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return (V)this.function.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.function.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    public static class UnmodifiableFunction<V>
    extends AbstractDouble2ReferenceFunction<V>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Double2ReferenceFunction<? extends V> function;

        protected UnmodifiableFunction(Double2ReferenceFunction<? extends V> f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
        }

        public int size() {
            return this.function.size();
        }

        @Override
        public V defaultReturnValue() {
            return (V)this.function.defaultReturnValue();
        }

        @Override
        public void defaultReturnValue(V defRetValue) {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(double k) {
            return this.function.containsKey(k);
        }

        public V put(double k, V v) {
            throw new UnsupportedOperationException();
        }

        public V get(double k) {
            return (V)this.function.get(k);
        }

        public V getOrDefault(double k, V defaultValue) {
            return (V)this.function.getOrDefault(k, defaultValue);
        }

        public V remove(double k) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public V put(Double k, V v) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public V get(Object k) {
            return (V)this.function.get(k);
        }

        @Deprecated
        public V getOrDefault(Object k, V defaultValue) {
            return (V)this.function.getOrDefault(k, defaultValue);
        }

        @Deprecated
        public V remove(Object k) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.function.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || this.function.equals(o);
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static class PrimitiveFunction<V>
    implements Double2ReferenceFunction<V> {
        protected final java.util.function.Function<? super Double, ? extends V> function;

        protected PrimitiveFunction(java.util.function.Function<? super Double, ? extends V> function) {
            this.function = function;
        }

        public boolean containsKey(double key) {
            return this.function.apply(key) != null;
        }

        @Deprecated
        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            return this.function.apply((Double)key) != null;
        }

        public V get(double key) {
            V v = this.function.apply(key);
            if (v == null) {
                return null;
            }
            return v;
        }

        public V getOrDefault(double key, V defaultValue) {
            V v = this.function.apply(key);
            if (v == null) {
                return defaultValue;
            }
            return v;
        }

        @Deprecated
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            return this.function.apply((Double)key);
        }

        @Deprecated
        public V getOrDefault(Object key, V defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            V v = this.function.apply((Double)key);
            return v == null ? defaultValue : v;
        }

        @Deprecated
        public V put(Double key, V value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class EmptyFunction<V>
    extends AbstractDouble2ReferenceFunction<V>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyFunction() {
        }

        public V get(double k) {
            return null;
        }

        public V getOrDefault(double k, V defaultValue) {
            return defaultValue;
        }

        public boolean containsKey(double k) {
            return false;
        }

        @Override
        public V defaultReturnValue() {
            return null;
        }

        @Override
        public void defaultReturnValue(V defRetValue) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        public Object clone() {
            return EMPTY_FUNCTION;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Function)) {
                return false;
            }
            return ((Function)o).size() == 0;
        }

        public String toString() {
            return "{}";
        }

        private Object readResolve() {
            return EMPTY_FUNCTION;
        }
    }
}

