/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.implementation.HttpProxyHandler;
import com.azure.core.http.netty.implementation.ReadTimeoutHandler;
import com.azure.core.http.netty.implementation.ResponseTimeoutHandler;
import com.azure.core.http.netty.implementation.WriteTimeoutHandler;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private static final long MINIMUM_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1L);
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private EventLoopGroup eventLoopGroup;
    private Configuration configuration;
    private boolean disableBufferCopy;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        AtomicReference proxyChallengeHolder;
        reactor.netty.http.client.HttpClient nettyHttpClient = this.baseHttpClient != null ? this.baseHttpClient : (this.connectionProvider != null ? reactor.netty.http.client.HttpClient.create((ConnectionProvider)this.connectionProvider) : reactor.netty.http.client.HttpClient.create());
        nettyHttpClient = nettyHttpClient.port(this.port).wiretap(this.enableWiretap).doOnRequest((request, connection) -> NettyAsyncHttpClientBuilder.addWriteTimeoutHandler(connection, NettyAsyncHttpClientBuilder.getTimeoutMillis(this.writeTimeout))).doAfterRequest((request, connection) -> NettyAsyncHttpClientBuilder.addResponseTimeoutHandler(connection, NettyAsyncHttpClientBuilder.getTimeoutMillis(this.responseTimeout))).doOnResponse((response, connection) -> NettyAsyncHttpClientBuilder.addReadTimeoutHandler(connection, NettyAsyncHttpClientBuilder.getTimeoutMillis(this.readTimeout))).doAfterResponseSuccess((response, connection) -> NettyAsyncHttpClientBuilder.removeReadTimeoutHandler(connection));
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions buildProxyOptions = this.proxyOptions == null && buildConfiguration != Configuration.NONE ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
        boolean useCustomProxyHandler = NettyAsyncHttpClientBuilder.shouldUseCustomProxyHandler(buildProxyOptions);
        AuthorizationChallengeHandler handler = useCustomProxyHandler ? new AuthorizationChallengeHandler(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()) : null;
        AtomicReference atomicReference = proxyChallengeHolder = useCustomProxyHandler ? new AtomicReference() : null;
        if (this.eventLoopGroup != null) {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.runOn(this.eventLoopGroup);
        }
        if (buildProxyOptions != null) {
            if (handler != null) {
                Pattern nonProxyHostsPattern = CoreUtils.isNullOrEmpty((CharSequence)buildProxyOptions.getNonProxyHosts()) ? null : Pattern.compile(buildProxyOptions.getNonProxyHosts(), 2);
                AddressResolverGroup resolver = ((HttpClientConfig)(nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.doOnChannelInit((connectionObserver, channel, socketAddress) -> {
                    if (NettyAsyncHttpClientBuilder.shouldApplyProxy(socketAddress, nonProxyHostsPattern)) {
                        channel.pipeline().addFirst("reactor.left.proxyHandler", (ChannelHandler)new HttpProxyHandler(AddressUtils.replaceWithResolved((InetSocketAddress)buildProxyOptions.getAddress()), handler, proxyChallengeHolder));
                    }
                })).configuration()).resolver();
                if (resolver == null) {
                    nettyHttpClient.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
                }
            } else {
                nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.proxy(proxy -> proxy.type(NettyAsyncHttpClientBuilder.toReactorNettyProxyType(buildProxyOptions.getType(), this.logger)).address(buildProxyOptions.getAddress()).username(buildProxyOptions.getUsername()).password(ignored -> buildProxyOptions.getPassword()).nonProxyHosts(buildProxyOptions.getNonProxyHosts()));
            }
        }
        return new NettyAsyncHttpClient(nettyHttpClient, this.disableBufferCopy);
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.eventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }

    public NettyAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private static boolean shouldUseCustomProxyHandler(ProxyOptions options) {
        return options != null && options.getUsername() != null && options.getType() == ProxyOptions.Type.HTTP;
    }

    private static ProxyProvider.Proxy toReactorNettyProxyType(ProxyOptions.Type azureProxyType, ClientLogger logger) {
        switch (azureProxyType) {
            case HTTP: {
                return ProxyProvider.Proxy.HTTP;
            }
            case SOCKS4: {
                return ProxyProvider.Proxy.SOCKS4;
            }
            case SOCKS5: {
                return ProxyProvider.Proxy.SOCKS5;
            }
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown 'ProxyOptions.Type' enum value"));
    }

    private static boolean shouldApplyProxy(SocketAddress socketAddress, Pattern nonProxyHostsPattern) {
        if (nonProxyHostsPattern == null) {
            return true;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return true;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !nonProxyHostsPattern.matcher(inetSocketAddress.getHostString()).matches();
    }

    private static void addWriteTimeoutHandler(Connection connection, long timeoutMillis) {
        connection.addHandlerLast("azureWriteTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler(timeoutMillis));
    }

    private static void addResponseTimeoutHandler(Connection connection, long timeoutMillis) {
        connection.removeHandler("azureWriteTimeoutHandler").addHandlerLast("azureResponseTimeoutHandler", (ChannelHandler)new ResponseTimeoutHandler(timeoutMillis));
    }

    private static void addReadTimeoutHandler(Connection connection, long timeoutMillis) {
        connection.removeHandler("azureResponseTimeoutHandler").addHandlerLast("azureReadTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(timeoutMillis));
    }

    private static void removeReadTimeoutHandler(Connection connection) {
        connection.removeHandler("azureReadTimeoutHandler");
    }

    static long getTimeoutMillis(Duration timeout) {
        if (timeout == null) {
            return DEFAULT_TIMEOUT;
        }
        if (timeout.isZero() || timeout.isNegative()) {
            return 0L;
        }
        return Math.max(timeout.toMillis(), MINIMUM_TIMEOUT);
    }
}

