/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.net.protocols.muxdemux.AbstractChannelReadInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullFrameChannelReadInterface
extends AbstractChannelReadInterface {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Deque<ByteBuffer> riEmptyStack;
    private final IChannelControlBlock ccb;
    private final Object bufferRecycleLock = new Object();
    private int frameSize;
    private long recycledBuffers = 0L;
    private long flushedBuffers = 0L;

    public FullFrameChannelReadInterface(IChannelControlBlock ccb) {
        this.ccb = ccb;
        this.riEmptyStack = new ArrayDeque<ByteBuffer>();
        this.credits = 0;
        this.emptyBufferAcceptor = buffer -> {
            int delta = buffer.remaining();
            if (this.bufferFactory != null && delta != this.frameSize) {
                LOGGER.warn("partial frame being recycled; expected size {}, actual size {}", (Object)this.frameSize, (Object)delta);
            }
            Object object = this.bufferRecycleLock;
            synchronized (object) {
                if (ccb.isRemotelyClosed()) {
                    return;
                }
                this.riEmptyStack.push(buffer);
                ++this.recycledBuffers;
                ccb.addPendingCredits(delta);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ISocketChannel sc, int size) throws IOException, NetException {
        Object object = this.bufferRecycleLock;
        synchronized (object) {
            while (true) {
                if (size <= 0) {
                    return size;
                }
                if (this.currentReadBuffer == null) {
                    this.currentReadBuffer = this.riEmptyStack.poll();
                    if (this.currentReadBuffer == null) {
                        this.currentReadBuffer = this.bufferFactory.createBuffer();
                    }
                }
                if (this.currentReadBuffer == null) {
                    this.logStats();
                    throw new IllegalStateException(this.ccb + " read buffers exceeded");
                }
                int rSize = Math.min(size, this.currentReadBuffer.remaining());
                if (rSize > 0) {
                    int len;
                    this.currentReadBuffer.limit(this.currentReadBuffer.position() + rSize);
                    try {
                        len = sc.read(this.currentReadBuffer);
                        if (len < 0) {
                            throw new NetException("Socket Closed");
                        }
                    }
                    finally {
                        this.currentReadBuffer.limit(this.currentReadBuffer.capacity());
                    }
                    size -= len;
                    if (len < rSize) {
                        return size;
                    }
                } else {
                    return size;
                }
                if (this.currentReadBuffer.remaining() > 0) continue;
                this.flush();
                ++this.flushedBuffers;
            }
        }
    }

    @Override
    public void setBufferFactory(IBufferFactory bufferFactory, int limit, int frameSize) {
        this.frameSize = frameSize;
        super.setBufferFactory(bufferFactory, limit, frameSize);
        this.ccb.addPendingCredits(limit * frameSize);
    }

    private void logStats() {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("{} read buffers exceeded; current empty buffers: {}, created buffers: {}, recycled buffers: {}, flushed buffers: {}", (Object)this.ccb, (Object)this.riEmptyStack.size(), (Object)this.bufferFactory.getCreatedBuffersCount(), (Object)this.recycledBuffers, (Object)this.flushedBuffers);
        }
    }
}

