/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PropertiesUtil;

public class StructuralPropertiesVector
implements IPhysicalPropertiesVector {
    private List<ILocalStructuralProperty> propsLocal;
    private IPartitioningProperty propPartitioning;
    public static final StructuralPropertiesVector EMPTY_PROPERTIES_VECTOR = new StructuralPropertiesVector(null, new ArrayList<ILocalStructuralProperty>());

    public StructuralPropertiesVector(IPartitioningProperty propPartitioning, List<ILocalStructuralProperty> propsLocal) {
        this.propPartitioning = propPartitioning;
        this.propsLocal = propsLocal;
    }

    public String toString() {
        return "propsLocal=" + this.propsLocal + "\tpropPartioning=" + this.propPartitioning;
    }

    @Override
    public IPartitioningProperty getPartitioningProperty() {
        return this.propPartitioning;
    }

    @Override
    public List<ILocalStructuralProperty> getLocalProperties() {
        return this.propsLocal;
    }

    @Override
    public IPhysicalPropertiesVector clone() {
        LinkedList<ILocalStructuralProperty> propsCopy = new LinkedList<ILocalStructuralProperty>();
        if (this.propsLocal != null) {
            propsCopy.addAll(this.propsLocal);
        }
        return new StructuralPropertiesVector(this.propPartitioning, propsCopy);
    }

    @Override
    public IPhysicalPropertiesVector getUnsatisfiedPropertiesFrom(IPhysicalPropertiesVector reqd, boolean mayExpandProperties, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        IPartitioningProperty normalizedPropPart;
        IPartitioningProperty normalizedReqPart;
        List<ILocalStructuralProperty> plist = reqd.getLocalProperties();
        List<ILocalStructuralProperty> diffLocals = null;
        if (plist != null && !plist.isEmpty() && !PropertiesUtil.matchLocalProperties(plist, this.propsLocal, equivalenceClasses, fds)) {
            diffLocals = plist;
        }
        IPartitioningProperty diffPart = null;
        IPartitioningProperty reqdPart = reqd.getPartitioningProperty();
        if (reqdPart != null && !PropertiesUtil.matchPartitioningProps(normalizedReqPart = reqdPart.normalize(equivalenceClasses, mayExpandProperties ? fds : null), normalizedPropPart = this.propPartitioning.normalize(equivalenceClasses, mayExpandProperties ? fds : null), mayExpandProperties)) {
            diffPart = reqdPart;
        }
        if (diffLocals == null && diffPart == null) {
            return null;
        }
        return new StructuralPropertiesVector(diffPart, diffLocals);
    }
}

