/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

public abstract class LocalMemoryRequirements {
    public abstract int getMinMemoryBudgetInFrames();

    public abstract int getMemoryBudgetInFrames();

    public abstract void setMemoryBudgetInFrames(int var1);

    public final long getMemoryBudgetInBytes(long frameSize) {
        return frameSize * (long)this.getMemoryBudgetInFrames();
    }

    public static LocalMemoryRequirements fixedMemoryBudget(int memBudgetInFrames) {
        if (memBudgetInFrames < 0) {
            throw new IllegalArgumentException(String.valueOf(memBudgetInFrames));
        }
        return memBudgetInFrames == FixedMemoryBudget.ONE_FRAME.memBudgetInFrames ? FixedMemoryBudget.ONE_FRAME : new FixedMemoryBudget(memBudgetInFrames);
    }

    public static LocalMemoryRequirements variableMemoryBudget(int minMemBudgetInFrames) {
        return new VariableMemoryBudget(minMemBudgetInFrames);
    }

    private static final class VariableMemoryBudget
    extends LocalMemoryRequirements {
        private final int minMemBudgetInFrames;
        private int memBudgetInFrames;

        private VariableMemoryBudget(int minMemBudgetInFrames) {
            this.memBudgetInFrames = this.minMemBudgetInFrames = minMemBudgetInFrames;
        }

        @Override
        public int getMinMemoryBudgetInFrames() {
            return this.minMemBudgetInFrames;
        }

        @Override
        public int getMemoryBudgetInFrames() {
            return this.memBudgetInFrames;
        }

        @Override
        public void setMemoryBudgetInFrames(int value) {
            if (value < this.minMemBudgetInFrames) {
                throw new IllegalArgumentException("Got " + value + ", expected " + this.minMemBudgetInFrames + " or more");
            }
            this.memBudgetInFrames = value;
        }
    }

    private static final class FixedMemoryBudget
    extends LocalMemoryRequirements {
        private static final FixedMemoryBudget ONE_FRAME = new FixedMemoryBudget(1);
        private final int memBudgetInFrames;

        private FixedMemoryBudget(int memBudgetInFrames) {
            this.memBudgetInFrames = memBudgetInFrames;
        }

        @Override
        public int getMinMemoryBudgetInFrames() {
            return this.memBudgetInFrames;
        }

        @Override
        public int getMemoryBudgetInFrames() {
            return this.memBudgetInFrames;
        }

        @Override
        public void setMemoryBudgetInFrames(int value) {
            if (value != this.memBudgetInFrames) {
                throw new IllegalArgumentException("Got " + value + ", expected " + this.memBudgetInFrames);
            }
        }
    }
}

