/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.List;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractWindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.AbstractWindowRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowAggregatorDescriptorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowMaterializingRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowNestedPlansRunningRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowNestedPlansRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowNestedPlansUnboundedRuntimeFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;

public final class WindowPOperator
extends AbstractWindowPOperator {
    public static final int MIN_FRAME_LIMIT_FOR_WINDOW = 5;
    private final boolean frameStartIsMonotonic;
    private final boolean frameEndIsMonotonic;
    private final boolean nestedTrivialAggregates;

    public WindowPOperator(List<LogicalVariable> partitionColumns, List<OrderColumn> orderColumns, boolean frameStartIsMonotonic, boolean frameEndIsMonotonic, boolean nestedTrivialAggregates) {
        super(partitionColumns, orderColumns);
        this.frameStartIsMonotonic = frameStartIsMonotonic;
        this.frameEndIsMonotonic = frameEndIsMonotonic;
        this.nestedTrivialAggregates = nestedTrivialAggregates;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.WINDOW;
    }

    @Override
    public void createLocalMemoryRequirements(ILogicalOperator op) {
        this.localMemoryRequirements = LocalMemoryRequirements.variableMemoryBudget(5);
    }

    @Override
    protected AbstractWindowRuntimeFactory createRuntimeFactory(WindowOperator winOp, int[] partitionColumnsList, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, IScalarEvaluatorFactory[] frameValueExprEvals, IBinaryComparatorFactory[] frameValueComparatorFactories, IScalarEvaluatorFactory[] frameStartExprEvals, IScalarEvaluatorFactory[] frameStartValidationExprEvals, IScalarEvaluatorFactory[] frameEndExprEvals, IScalarEvaluatorFactory[] frameEndValidationExprEvals, IScalarEvaluatorFactory[] frameExcludeExprEvals, IBinaryComparatorFactory[] frameExcludeComparatorFactories, IScalarEvaluatorFactory frameExcludeUnaryExprEval, IScalarEvaluatorFactory frameOffsetExprEval, int[] projectionColumnsExcludingSubplans, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, int nestedAggOutSchemaSize, WindowAggregatorDescriptorFactory nestedAggFactory, JobGenContext context) {
        boolean hasFrameOffset;
        int memSizeInFrames = this.localMemoryRequirements.getMemoryBudgetInFrames();
        if (!winOp.hasNestedPlans()) {
            return new WindowMaterializingRuntimeFactory(partitionColumnsList, partitionComparatorFactories, orderComparatorFactories, projectionColumnsExcludingSubplans, runningAggOutColumns, runningAggFactories, memSizeInFrames);
        }
        boolean hasFrameStart = frameStartExprEvals != null && frameStartExprEvals.length > 0;
        boolean hasFrameEnd = frameEndExprEvals != null && frameEndExprEvals.length > 0;
        boolean hasFrameExclude = frameExcludeExprEvals != null && frameExcludeExprEvals.length > 0;
        boolean hasFrameExcludeUnary = frameExcludeUnaryExprEval != null;
        boolean bl = hasFrameOffset = frameOffsetExprEval != null;
        if (!(hasFrameStart || hasFrameExclude || hasFrameExcludeUnary || hasFrameOffset)) {
            if (!hasFrameEnd) {
                return new WindowNestedPlansUnboundedRuntimeFactory(partitionColumnsList, partitionComparatorFactories, orderComparatorFactories, winOp.getFrameMaxObjects(), projectionColumnsExcludingSubplans, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, memSizeInFrames);
            }
            if (this.frameEndIsMonotonic && this.nestedTrivialAggregates) {
                nestedAggFactory.setPartialOutputEnabled(true);
                return new WindowNestedPlansRunningRuntimeFactory(partitionColumnsList, partitionComparatorFactories, orderComparatorFactories, frameValueExprEvals, frameValueComparatorFactories, frameEndExprEvals, frameEndValidationExprEvals, winOp.getFrameMaxObjects(), context.getBinaryBooleanInspectorFactory(), projectionColumnsExcludingSubplans, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, memSizeInFrames);
            }
        }
        return new WindowNestedPlansRuntimeFactory(partitionColumnsList, partitionComparatorFactories, orderComparatorFactories, frameValueExprEvals, frameValueComparatorFactories, frameStartExprEvals, frameStartValidationExprEvals, this.frameStartIsMonotonic, frameEndExprEvals, frameEndValidationExprEvals, frameExcludeExprEvals, winOp.getFrameExcludeNegationStartIdx(), frameExcludeComparatorFactories, frameExcludeUnaryExprEval, frameOffsetExprEval, winOp.getFrameMaxObjects(), context.getBinaryBooleanInspectorFactory(), context.getBinaryIntegerInspectorFactory(), projectionColumnsExcludingSubplans, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, memSizeInFrames);
    }
}

